# encoding: utf-8
import sys
from H_9U.util.log import logger
from H_9U import get_app
from flask_cors import CORS

logger.info("...........系统开始运行  System starts to run ...........")

app = get_app()
CORS(app, supports_credentials=True)

app.config['JSON_AS_ASCII'] = False

def handle_exception(exc_type, exc_value, exc_traceback):
    if issubclass(exc_type, KeyboardInterrupt):
        sys.__excepthook__(exc_type, exc_value, exc_traceback)
        return
    logger.error("Uncaught exception", exc_info=(exc_type, exc_value, exc_traceback))


sys.excepthook = handle_exception

if __name__ == '__main__':
    app.run(host='0.0.0.0', port=8000, debug=False, threaded=True)
