"""
Created on 2019年6月28日
@author: 刘益宗
日志装饰器
"""
import inspect
import time
from functools import wraps

from flask.globals import g
from flask.globals import request
from flask.json import jsonify

from H_9U.util.log import logger, log_info


# api层 日志装饰器
def api_log(func):
    """
    api日志装饰器，用于api
    :param func: 装饰函数
    :return:  原函数返回值
    """
    @wraps(func)
    def wrapper(*args, **kwargs):
        # 调用时间
        start = time.monotonic()
        # 请求参数
        req_str = ''
        try:
            req_str = request.get_data().decode()
        except:
            pass
        # 调用原函数
        t = jsonify({'status': 500, 'msg': 'Server_Err', 'data': {}})
        try:
            t = func(*args, **kwargs)
        except Exception as e:
            logger.exception(e)
            logger.error("API:%s,%s---接口:%s出现异常，请求：%s,异常消息：%s" %
                         (g.user['username'] if 'user' in g else "anony",
                          g.ip,
                          func.__name__,
                          req_str,
                          str(e)))
        """
        # 调用时间
        sec = round(time.monotonic() - start,2)
        # 记录日志
        log_info("API end:%s,%s---接口:%s，请求：%s,返回：%s，耗时：%s %s" %
                    (g.user['username'] if 'user' in g else "anony",
                     g.ip,
                     func.__name__,
                     "", t, str(sec)+'秒', ',耗时异常' if sec > 3 else ''))
        """
        return t

    return wrapper


def open_log(func):
    """
    api日志装饰器，用于api
    :param func: 装饰函数
    :return:  原函数返回值
    """
    @wraps(func)
    def wrapper(*args, **kwargs):
        # 调用时间
        start = time.monotonic()
        # 请求参数
        req_str = ''
        try:
            req_str = request.get_data().decode()
        except:
            pass
        # 调用原函数
        t = jsonify({'status': 500, 'msg': 'Server_Err', 'data': {}})
        try:
            t = func(*args, **kwargs)
        except Exception as e:
            logger.exception(e)
            logger.error("%s: OpenAPI接口%s出现异常，请求：%s,异常消息：%s" % (g.project_name, func.__name__, req_str, str(e)))
        # 调用时间
        sec = time.monotonic() - start
        # 记录日志
        logger.info("%s: OpenAPI接口%s，请求：%s,返回：%s，耗时：%s %s" % (g.project_name, func.__name__, "", t, str(sec), ',耗时异常' if sec > 3 else ''))
        return t

    return wrapper

# mao层 日志装饰器
def log_wrapper(func):
    """
    日志装饰器,用于所有函数
    :param func: 装饰函数
    :return:  原函数返回值
    """
    @wraps(func)
    def wrapper(*args, **kwargs):
        # 调用时间
        start = time.monotonic()
        # 调用原函数
        try:
            t = func(*args, **kwargs)
        except Exception as e:
            logger.exception(e)
            logger.error("mao层函数:%s异常，请求args:%s,请求kwargs:%s, 异常信息：%s" % (func.__name__, str(args), str(kwargs), str(e)))
            t = {'status': 500, 'msg': '', 'data': {}}
        # 调用时间
        sec = time.monotonic() - start
        # 记录日志
        # # logger.debug(
        #     "接口%s，请求args:%s,请求kwargs:%s,返回：%s，耗时：%s" % (func.__name__, str(args), str(kwargs), str(t), str(sec)))

        if t['status'] != 0 or sec > 3:
            log_info("mao层函数:%s，请求args:%s,请求kwargs:%s,返回：%s，耗时：%s %s" %
                        (func.__name__, str(args), str(kwargs), t, str(sec), ',耗时异常' if sec > 3 else ''))
        else:
            #log_info("请求3.5代协议:%s，请求args:%s,请求kwargs:%s,返回：%s，耗时：%s" % (func.__name__, "", "", t['status'], str(sec * 1000)))
            log_info(f"mao层函数: {func.__name__},执行时间: {sec * 1000:.2f} 毫秒")
        return t

    return wrapper


# 统计函数的执行时间
def time_statistics(func):
    def wrapper(*args, **kwargs):
        start_time = time.perf_counter()
        result = func(*args, **kwargs)
        end_time = time.perf_counter()

        # 获取调用堆栈信息
        frame = inspect.currentframe().f_back  # 获取上一级调用栈
        info = inspect.getframeinfo(frame)
        execution_time = (end_time - start_time) * 1000

        index = info.filename.find('H_9U')  # 找到 'H_9U' 的起始位置
        log_file_name = info.filename[index:] if index != -1 else info.filename
        log_info(f"文件:{log_file_name}第{info.lineno}行,函数:{func.__name__},执行时间: {execution_time:.2f} 毫秒")
        return result

    return wrapper