"""
@Project ：h_series 
@File    ：logutil.py
@IDE     ：PyCharm 
@Author  ：程声清
@Date    ：2023/5/4 11:10 
"""
from H_9U.dao.log import logdao
from flask import g


class LogType:
    """
    设备日志类型
    """
    Login = 1  # 登录日志
    Operation = 2  # 操作日志
    Warning = 3  # 报警日志


class LogOperation:
    """
    log操作
    """
    Login = 'login'  # 登录日志
    Logout = 'logout'
    Add = 'add'
    Edit = 'edit'
    Delete = 'delete'
    View = 'view'


class LogModule:
    """
    log模块
    """
    Login = 1  # 登录日志
    User = 2
    Role = 3
    Session = 4
    Device = 5
    Slot = 6


class LogFunction:
    Login = 'Login'  # 登录日志
    User = 'User'
    Role = 'Role'
    Session = 'Session'

    Genlock = 'Genlock'
    Slot_Function = 'Slot_Function'
    IP = 'Device_IP'
    COM = 'Device_COM'
    Restore = 'Device_Restore'
    Shutdown = 'Device_Shutdown'
    Effective_Time = 'Device_Effective_Time'
    IPC_Mode = 'IPC_Mode'
    Background_Color = 'Device_Background_Color'
    Slot = 'Device_Slot'
    Upgrade = 'Upgrade'
    Nomark = 'Nomark'
    Import_Settings = 'Import_Settings'
    Export_Settings = 'export_Settings'
    Self_Check = 'Self_Check'


class LogClient:
    Web = 1
    OpenApi = 2
    LCDPanel =3


def add_login_log(user_name, user_id, is_success):
    try:
        ip = g.ip
        detail = 'user：{0} login: {1}'.format(user_name, 'success' if is_success else 'fail')
        logdao.add(LogType.Login, ip, LogModule.Login, LogFunction.Login, LogOperation.Login, detail, user_name, user_id, LogClient.Web)
    except:
        pass


def add_opt_log(log_module, module_function,  log_opt, detail):
    try:
        ip = g.ip
        user_name = g.user['username']
        user_id = g.user['id']
        if not isinstance(detail, str):
            detail = str(detail)
        logdao.add(LogType.Operation, ip, log_module, module_function, log_opt, detail, user_name, user_id, LogClient.Web)
    except:
        pass