
import os
import socket
import struct
import select
import time




ICMP_ECHO_REQUEST = 8  # ICMP Echo Request类型
DEFAULT_TIMEOUT = 2  # 默认超时时间，单位为秒
DEFAULT_COUNT = 4  # 默认ping的次数

# 计算校验和
def checksum(source_string):
    sum = 0
    count_to = (len(source_string) // 2) * 2
    count = 0
    while count < count_to:
        this_val = source_string[count + 1] * 256 + source_string[count]
        sum = sum + this_val
        sum = sum & 0xffffffff
        count = count + 2
    if count_to < len(source_string):
        sum = sum + source_string[len(source_string) - 1]
        sum = sum & 0xffffffff
    sum = (sum >> 16) + (sum & 0xffff)
    sum = sum + (sum >> 16)
    answer = ~sum
    answer = answer & 0xffff
    answer = answer >> 8 | (answer << 8 & 0xff00)
    return answer

# 发送ICMP消息
def send_icmp_request(dest_addr, icmp_id, icmp_seq):
    sock = socket.socket(socket.AF_INET, socket.SOCK_RAW, socket.getprotobyname("icmp"))
    sock.setsockopt(socket.SOL_IP, socket.IP_TTL, 255)
    icmp_header = struct.pack("!BBHHH", ICMP_ECHO_REQUEST, 0, 0, icmp_id, icmp_seq)
    icmp_checksum = checksum(icmp_header)
    icmp_header = struct.pack("!BBHHH", ICMP_ECHO_REQUEST, 0, icmp_checksum, icmp_id, icmp_seq)
    send_time = time.time()
    sock.sendto(icmp_header, (dest_addr, 1))
    return send_time, sock

# 接收ICMP消息
def receive_icmp_reply(sock, icmp_id, timeout):
    while True:
        select_start = time.time()
        ready = select.select([sock], [], [], timeout)
        select_duration = time.time() - select_start
        if ready[0] == []:  # 超时
            return None
        receive_time = time.time()
        packet_data, addr = sock.recvfrom(1024)
        icmp_header = packet_data[20:28]
        icmp_type, code, checksum, packet_id, sequence = struct.unpack("!BBHHH", icmp_header)
        if icmp_type == 0 and packet_id == icmp_id:  # Echo Reply
            return receive_time - select_start

# ping指定IP
def ping(dest_addr, timeout=DEFAULT_TIMEOUT, count=DEFAULT_COUNT):
    flag = False
    for i in range(count):
        icmp_id = os.getpid() & 0xFFFF
        icmp_seq = i
        send_time, sock = send_icmp_request(dest_addr, icmp_id, icmp_seq)
        duration = receive_icmp_reply(sock, icmp_id, timeout)
        if duration is None:
            flag = False
        else:
            flag = True
    return flag