"""
Created on 2019年6月28日
@author: 刘益宗
公用方法，格式化数据
"""
from decimal import Decimal

# 关键字和格式化比例
key_rate = {'refreshRate': 100, 'gamma': 100, 'refresh': 100, 'time': 10, 'effectTime': 10}


def format_server_data(data):
    """
    格式化服务端数据
    :param data: 被格式化数据
    :return: None
    """
    if isinstance(data, dict):
        for key in data.keys():
            if isinstance(data[key], dict):
                format_server_data(data[key])
            elif isinstance(data[key], list):
                format_server_data(data[key])
            elif key in key_rate.keys():
                data[key] = data[key] / key_rate[key]
    elif isinstance(data, list):
        for item in data:
            if isinstance(item, dict):
                format_server_data(item)
            elif isinstance(item, list):
                format_server_data(item)


def format_client_data(data):
    """
    格式化客户端数据
    :param data: 被格式化数据
    :return:
    """
    if isinstance(data, dict):
        for key in data.keys():
            if isinstance(data[key], dict):
                format_client_data(data[key])
            if isinstance(data[key], list):
                format_client_data(data[key])
            elif key in key_rate.keys():
                data[key] = int(Decimal(str(data[key])) * Decimal(str(key_rate[key])))
    elif isinstance(data, list):
        for item in data:
            if isinstance(item, dict):
                format_client_data(item)
            elif isinstance(item, list):
                format_client_data(item)


