"""
Created on 2019年6月28日
@author: 刘益宗
文件解压
"""

import os
import tarfile
import zipfile
import traceback
import shutil
from H_9U.util.log import logger


def extract(file_path, extract_to_path):
    # 如果文件是zip格式则进行解压缩
    ext = file_path.rsplit('.', 1)[1]
    extract_bln = False
    if ext in ['zip', 'gz']:
        # 删除之前解压的文件
        try:
            if os.path.exists(extract_to_path):
                shutil.rmtree(extract_to_path)
        except Exception:
            msg = traceback.format_exc()
        # 解压缩2
        extract_bln = extract_file(file_path, extract_to_path)
        # 删除上传文件
        os.remove(file_path)
        if extract_bln == False:
            try:
                if os.path.exists(extract_to_path):
                    shutil.rmtree(extract_to_path)
            except Exception:
                msg = traceback.format_exc()
    return extract_bln


def pd_extract(file_path, extract_to_path, package_pwd):
    # 如果文件是zip格式则进行解压缩
    ext = file_path.rsplit('.', 1)[1]
    extract_bln = False
    if ext in ['zip', 'gz']:
        # 删除之前解压的文件
        try:
            if os.path.exists(extract_to_path):
                shutil.rmtree(extract_to_path)
        except Exception:
            msg = traceback.format_exc()
            # 使用密码解压缩
        try:
            # 调用unzip命令解压ZIP文件
            if is_zip_encrypted(file_path):
                cmd = "unzip -P '{}' -d '{}' '{}'".format(package_pwd, extract_to_path, file_path)
                cmd_rs = os.system(cmd)
                if cmd_rs == 0:
                    logger.info('使用密码解压压缩包成功')
                    extract_bln = True
        except Exception as e:
            logger.error('升级包解压失败或密码错误: %s' % e)
            extract_bln = False
        if extract_bln == False:
            try:
                if os.path.exists(extract_to_path):
                    shutil.rmtree(extract_to_path)
            except Exception:
                msg = traceback.format_exc()
                logger.error(msg)
    return extract_bln


def is_zip_encrypted(file_path):
    with zipfile.ZipFile(file_path) as zf:
        for info in zf.infolist():
            if info.flag_bits & 0x01:
                return True
    return False


def extract_file(file_absolute_path_name, extract_to_path):
    """
    解压文件
    :param file_absolute_path_name: 压缩文件绝对路径
    :param extract_to_path: 解压路径
    :return: 成功失败
    """
    if not os.path.exists(file_absolute_path_name) or not os.path.isfile(file_absolute_path_name):
        return False

    ext = os.path.splitext(file_absolute_path_name)[1]
    if ext not in ('.zip', '.gz'):
        return False

    if not os.path.exists(extract_to_path):
        os.makedirs(extract_to_path)

    try:
        if ext == '.zip':
            zip_file_contents = zipfile.ZipFile(file_absolute_path_name, 'r')

            for file in zip_file_contents.filelist:
                filename = file.filename.encode('cp437').decode('gbk')  # 先使用cp437编码，然后再使用gbk解码
                file.filename = filename
                zip_file_contents.extract(file, extract_to_path)  # 解压缩ZIP文件
                # os.chdir(extract_to_path)  # 切换到目标目录(导致无法删除extractToPath目录)
                # fileR = os.path.join(extract_to_path, file);
                # filenameR = os.path.join(extract_to_path, filename);
                # os.rename(fileR, filenameR)  # 重命名文件

            zip_file_contents.close()
        elif ext == '.gz':
            t = tarfile.open(file_absolute_path_name)
            t.extractall(path=extract_to_path)
            t.close()

        # elif ext == '.rar':
        #     Archive(fileAbsolutePathName).extractall(extractToPath)

    except Exception:
        msg = traceback.format_exc()
        # logger.error('解压文件时出现异常:%s' % msg);
        print(msg)
        return False
    else:
        return True


if __name__ == '__main__':
    extract_file(r'E:\ziptest\qiangzhi10bit.zip', r'E:\ziptest\target')
    # zip_file_contents = zipfile.ZipFile(r'E:\ziptest\qiangzhi10bit.zip')
    # for zip_info in (zip_file_contents.filelist):
    #     filename = zip_info.filename.encode('cp437').decode('gbk')
    #     print(filename, zip_info)
    #     zip_info.filename = filename
    #     zip_file_contents.extract(zip_info,  r'E:\ziptest\target')


