import json
import os

from H_9U import get_result_model, log_info
from H_9U.models.cachekey import CacheKey, CacheDuration
from H_9U.util.cache import cacher
from H_9U.util.log import log_error


def get_bing_map_key_from_cache(device_id):
    cache_key = CacheKey.device_bing_map(device_id)
    return cacher.DeviceCache.try_get_value(cache_key, CacheDuration.Long, get_bing_map_key)

def get_bing_map_key():
    """
        从/usr/Hseries/bin/web/snmp/bingMapKey.json文件中读取key
        如果文件不存在、为空、格式错误或没有key字段，都返回空字符串
    """
    rs = get_result_model()
    file_path = "/usr/Hseries/bin/web/snmp/bingMapKey.json"
    log_info("从文件中读取bing/baidu地图密钥:%s", file_path)

    if not os.path.exists(file_path):
        log_error("文件不存在")
        return rs

    if os.path.getsize(file_path) == 0:
        log_error("文件内容为空")
        return rs

    try:
        with open(file_path, 'r', encoding='utf-8') as f:
            content = f.read().strip()

        if not content:
            return rs

        data = json.loads(content)

        data_dict = {}
        if isinstance(data, dict) and 'bing' in data and isinstance(data['bing'], str):
            data_dict = {
                "bing" :data['bing'],
                "baidu": data['baidu'],
            }
            rs['data'] = data_dict
        else:
            log_error("json数据错误")
    except json.JSONDecodeError as e:
        log_error(f"JSON解析错误: {e} - 文件: {file_path}")
        return rs
    except UnicodeDecodeError as e:
        log_error(f"文件编码错误: {e} - 文件: {file_path}")
        return rs
    except PermissionError as e:
        log_error(f"文件权限错误: {e} - 文件: {file_path}")
        return rs
    except Exception as e:
        log_error(f"未知错误: {e} - 文件: {file_path}")
        return rs
    return rs

