"""
@Project ：h_series 
@File    ：security.py
@IDE     ：PyCharm 
@Author  ：程声清
@Date    ：2023/5/4 11:02 
"""
from H_9U.dao.security_dao import securitydao
from H_9U.models.cachekey import CacheKey, CacheDuration
from H_9U.models.sysconst import SecurityMode, SecurityConfigType, NormalModeSettings, SafeModeSettings
from H_9U.util.cache import cacher
from H_9U.models.result import get_result_model

class SecurityApi:

    def _security_mode_read(self):
        return securitydao.security_config_read(SecurityConfigType.SecurityModeConfig)

    def _settings_read(self, device_id):
        """读取全部安全配置"""
        return securitydao.security_config_read_all()

    def _password_rule_read(self, device_id):
        return securitydao.security_config_read(SecurityConfigType.PwdConfig)

    def _login_rule_read(self, device_id):
        return securitydao.security_config_read(SecurityConfigType.LoginConfig)

    def _settings_write(self, k , v):
        rs = securitydao.security_config_write(k, v)
        if rs['status'] == 0:
            cacher.SecurityCache.clear()
        return rs

    def _security_config_reset(self, key, data):
        rs = securitydao.security_config_write(key, data)
        if rs['status'] == 0:
            cacher.SecurityCache.clear()
            rs['data'] = data
        return rs

class SecuritySvc(SecurityApi):

    def settings_read(self, device_id):
        key = CacheKey.security_config_all(device_id)
        rs = cacher.SecurityCache.get(key)
        if rs:
            return rs
        rs = self._settings_read(device_id)
        if rs['status'] == 0:
            cacher.SecurityCache.set(key, rs, CacheDuration.Long)
        return rs

    def password_rule_read(self, device_id):
        """读取密码安全配置"""
        # 方案1
        # key = CacheKey.security_config_all(device_id)
        # rs = cacher.SecurityCache.get(key)
        # if rs['data']:
        #     pwd_config = rs['data']['pwdConfig']
        #     if pwd_config is not None:
        #         rs['data'] = pwd_config
        #         return rs
        # return self._password_rule_read(device_id)

        # 2.方案2
        key = CacheKey.security_config_detail(SecurityConfigType.PwdConfig)
        rs = cacher.SecurityCache.get(key)
        if rs:
            return rs
        rs = self._password_rule_read(device_id)
        if rs['status'] == 0:
            cacher.SecurityCache.set(key, rs, CacheDuration.Long)
        return rs


    def login_rule_read(self, device_id):
        """读取登录安全配置"""
        key = CacheKey.security_config_detail(SecurityConfigType.LoginConfig)
        rs = cacher.SecurityCache.get(key)
        if rs:
            return rs
        rs = self._login_rule_read(device_id)
        if rs['status'] == 0:
            cacher.SecurityCache.set(key, rs, CacheDuration.Long)
        return rs

    def settings_write(self, params):
        """设置安全配置"""
        rs = get_result_model()
        for k, v in params.items():
            rs = self._settings_write(k, v)
        return rs

    def security_config_reset(self, key):
        rs = self.security_mode_read()
        if rs['status'] == 0:
            mode = rs['data']['mode']
            data = None
            if mode == SecurityMode.Normal:
                data = NormalModeSettings[key]
            elif mode == SecurityMode.Safe:
                data = SafeModeSettings[key]
            if data:
                rs = self._security_config_reset(key, data)
        return rs

    def settings_reset_all(self, mode):
        data = None
        if mode == SecurityMode.Normal:
            data = NormalModeSettings
        elif mode == SecurityMode.Safe:
            data = SafeModeSettings
        if data:
            data['securityModeConfig'] = {'mode': mode}
        rs = self.settings_write(data)
        rs['data'] = data
        return rs

    def security_mode_read(self):
        rs = self._security_mode_read()
        if rs['status'] == 0 and not rs['data']:
            rs['data'] = {"mode": SecurityMode.Default}
        return rs

securitysvc = SecuritySvc()