'''
Created on 2019年6月12日
@author: GongQingBao
    1.计算/统计Socket通讯使用的时间.
    2.当fncCode为'强制保存'操作时会输出统计数据到日志文件中.
'''

from H_9U.protocol.SQueue import SQueue
from H_9U.util.log import logger
from H_9U.protocol.radix import toHexDual
from H_9U.protocol.statcalltime import output_func_time

class CalUsedTime(object):

    def __init__(self):
        self.countUp20 = 0;
        self.count20 = 0;
        self.count10 = 0;
        self.count5 = 0;
        self.count3 = 0;
        self.count2 = 0;
        self.count1 = 0;
        self.count005 = 0;
        self.count002 = 0;
        self.count001 = 0;
        self.count05 = 0;
        self.count03 = 0;
        self.countDown03 = 0;
        self.totalTime = 0;  # 毫秒
        self.totalCount = 0;

        self.countUp20FnCodeLst = set();
        self.count20FnCodeLst = set();
        self.count10FnCodeLst = set();
        self.count5FnCodeLst = set();
        self.count3FnCodeLst = set();
        self.count2FnCodeLst = set();
        self.count1FnCodeLst = set();
        self.count005FnCodeLst = set();
        self.count002FnCodeLst = set();
        self.count001FnCodeLst = set();
        self.count05FnCodeLst = set();
        self.count03FnCodeLst = set();
        self.countDown03FnCodeLst = set();
        
        self.countUp20FnCodeLst_w = set();
        self.count20FnCodeLst_w = set();
        self.count10FnCodeLst_w = set();
        self.count5FnCodeLst_w = set();
        self.count3FnCodeLst_w = set();
        self.count2FnCodeLst_w = set();
        self.count1FnCodeLst_w = set();
        self.count005FnCodeLst_w = set();
        self.count002FnCodeLst_w = set();
        self.count001FnCodeLst_w = set();
        self.count05FnCodeLst_w = set();
        self.count03FnCodeLst_w = set();
        self.countDown03FnCodeLst_w = set();
        
        self.countTimeoutFnCodeLst = set();
        self.countTimeoutFnCodeLst_w = set();
        
        self.fnCodeQueue = SQueue(3);


    # 统计并打印耗时.
    # 参数：
    #    startTime-开始时间[时间的时间戳（1970纪元后经过的浮点秒数）];
    #    endTime-结束时间[时间的时间戳（1970纪元后经过的浮点秒数）];
    #    fnCode-功能编码;
    #    optType-操作类型[0-读,1-写];
    # 返回值：无
    def statisticsUsedTime(self, startTime, endTime, fnCode, optType):
        du = (endTime - startTime) * 1000; # 毫秒
        self.totalTime += du;
        self.totalCount += 1;
        duSecond = du/1000; # 秒
        
        fnCodeHex = toHexDual(fnCode);
        fnCodeStr = fnCodeHex + str(self.fnCodeQueue.getAll());
        self.fnCodeQueue.add(fnCodeHex);

        if optType == 0:
            if duSecond >= 20:
                self.countUp20 += 1;
                self.countUp20FnCodeLst.add(fnCodeStr);
            elif duSecond >= 10 and duSecond < 20:
                self.count10 += 1;
                self.count10FnCodeLst.add(fnCodeStr);
            elif duSecond >= 5 and duSecond < 10:
                self.count5 += 1;
                self.count5FnCodeLst.add(fnCodeStr);
            elif duSecond >= 3 and duSecond < 5:
                self.count3 += 1;
                self.count3FnCodeLst.add(fnCodeStr);
            elif duSecond >= 2 and duSecond < 3:
                self.count2 += 1;
                self.count2FnCodeLst.add(fnCodeStr);
            elif duSecond >= 1 and duSecond < 2:
                self.count1 += 1;
                self.count1FnCodeLst.add(fnCodeStr);
            elif du >= 500 and du < 1000:
                self.count005 += 1;
                self.count005FnCodeLst.add(fnCodeStr);
            elif du >= 200 and du < 500:
                self.count002 += 1;
                self.count002FnCodeLst.add(fnCodeStr);
            elif du >= 100 and du < 200:
                self.count001 += 1;
                self.count001FnCodeLst.add(fnCodeStr);
            elif du >= 50 and du < 100:
                self.count05 += 1;
                self.count05FnCodeLst.add(fnCodeStr);
            elif du >= 30 and du < 50:
                self.count03 += 1;
                self.count03FnCodeLst.add(fnCodeStr);
            elif du < 30:
                self.countDown03 += 1;
                self.countDown03FnCodeLst.add(fnCodeStr);
        
        elif optType == 1:
            if duSecond >= 20:
                self.countUp20 += 1;
                self.countUp20FnCodeLst_w.add(fnCodeStr);
            elif duSecond >= 10 and duSecond < 20:
                self.count10 += 1;
                self.count10FnCodeLst_w.add(fnCodeStr);
            elif duSecond >= 5 and duSecond < 10:
                self.count5 += 1;
                self.count5FnCodeLst_w.add(fnCodeStr);
            elif duSecond >= 3 and duSecond < 5:
                self.count3 += 1;
                self.count3FnCodeLst_w.add(fnCodeStr);
            elif duSecond >= 2 and duSecond < 3:
                self.count2 += 1;
                self.count2FnCodeLst_w.add(fnCodeStr);
            elif duSecond >= 1 and duSecond < 2:
                self.count1 += 1;
                self.count1FnCodeLst_w.add(fnCodeStr);
            elif du >= 500 and du < 1000:
                self.count005 += 1;
                self.count005FnCodeLst_w.add(fnCodeStr);
            elif du >= 200 and du < 500:
                self.count002 += 1;
                self.count002FnCodeLst_w.add(fnCodeStr);
            elif du >= 100 and du < 200:
                self.count001 += 1;
                self.count001FnCodeLst_w.add(fnCodeStr);
            elif du >= 50 and du < 100:
                self.count05 += 1;
                self.count05FnCodeLst_w.add(fnCodeStr);
            elif du >= 30 and du < 50:
                self.count03 += 1;
                self.count03FnCodeLst_w.add(fnCodeStr);
            elif du < 30:
                self.countDown03 += 1;
                self.countDown03FnCodeLst_w.add(fnCodeStr);

        # 输出日志信息
        if fnCode != None and fnCode == 0x0109:
            self.printLog();


    # 统计耗时-将超时加入统计数据中.
    # 参数：
    #    fnCode-功能编码;
    #    optType-操作类型[0-读,1-写];
    # 返回值：无
    def recordTimeout(self, fnCode, optType):
        fnCodeHex = toHexDual(fnCode);
        fnCodeStr = fnCodeHex + str(self.fnCodeQueue.getAll());
        self.fnCodeQueue.add(fnCodeHex);       
        
        if optType == 0:
            self.countTimeoutFnCodeLst.add(fnCodeStr);
        elif optType == 1:
            self.countTimeoutFnCodeLst_w.add(fnCodeStr);
        
        self.printLog(); # 输出日志信息


    # 输出日志信息
    def printLog(self):
        logger.warning("Up20:%i,Up10:%i,Up5:%i,Up3:%i,Up2:%i,Up1:%i,Up005:%i,Up002:%i,Up001:%i,Up05:%i,Up03:%i,Down03:%i" % (self.countUp20,self.count10,self.count5,self.count3,self.count2,self.count1,self.count005,self.count002,self.count001,self.count05,self.count03,self.countDown03));
        logger.warning("(毫秒)totalTime:%i,avgTime:%i" % (self.totalTime,(self.totalTime/self.totalCount)));
        logger.warning("读时间统计.Up20:%s,Up10:%s,Up5:%s,Up3:%s,Up2:%s,Up1:%s,Up005:%s,Up002:%s,Up001:%s,Up05:%s,Up03:%s" % (self.countUp20FnCodeLst,self.count10FnCodeLst,self.count5FnCodeLst,self.count3FnCodeLst,self.count2FnCodeLst,self.count1FnCodeLst,self.count005FnCodeLst,self.count002FnCodeLst,self.count001FnCodeLst,self.count05FnCodeLst,self.count03FnCodeLst));
        logger.warning("写时间统计.Up20:%s,Up10:%s,Up5:%s,Up3:%s,Up2:%s,Up1:%s,Up005:%s,Up002:%s,Up001:%s,Up05:%s,Up03:%s" % (self.countUp20FnCodeLst_w,self.count10FnCodeLst_w,self.count5FnCodeLst_w,self.count3FnCodeLst_w,self.count2FnCodeLst_w,self.count1FnCodeLst_w,self.count005FnCodeLst_w,self.count002FnCodeLst_w,self.count001FnCodeLst_w,self.count05FnCodeLst_w,self.count03FnCodeLst_w));
        logger.warning("超时统计-读.timeout:%s" % (self.countTimeoutFnCodeLst));
        logger.warning("超时统计-写.timeout:%s" % (self.countTimeoutFnCodeLst_w));
        logger.warning(output_func_time());



calUsedTime = CalUsedTime();


