"""
Created on 2021年11月01日
@author: 程声清
Ipc业务处理层.
返回值统一为 {data:JSON结构体, msg:"", status:0}
"""
from H_9U.mao.ipc_mao import ipc_api


def ipc_read_source_list_middle(device_id, data):
    """
    读取信号源列表，data为分页数据
    :param device_id: 设备Id
    :param data: 分页参数
    :return 结果数据
    """
    return ipc_api.read_ipc_source_list(device_id, data)


def ipc_read_source_detail(device_id, source_id):
    return ipc_api.ipc_source_detail_Info(device_id, source_id)


def ipc_read_camera_list_middle(device_id, decode_capacity):
    """
    ipc摄像头列表
    :param device_id: 设备id
    :param slot_id: slot id
    :return: 摄像头列表
    """
    return ipc_api.read_ipc_camera_list(device_id, decode_capacity)


def ipc_read_ipc_channel_list_middle(device_id, source_id):
    """
    读取ipc通道列表
    :param device_id: 设备id
    :param source_id: source id
    :return: ipc列表
    """
    return ipc_api.read_ipc_channel_list(device_id, source_id)


def ipc_read_channel_detail_middle(device_id, source_id, channel_id):
    """
    读取ipc通道详情
    :param device_id: 设备id
    :param source_id: source_id
    :param channel_id: channel_id
    :return: ipc列表
    """
    return ipc_api.read_ipc_channel_detail(device_id, source_id, channel_id)


def ipc_read_channel_detail_list_middle(device_id, source_id):
    """
    读取ipc通道详情列表
    :param device_id: 设备id
    :param source_id: source id
    :return: ipc列表
    """
    return ipc_api.ipc_channel_detail_list(device_id, source_id)


def ipc_slot_source_count_middle(device_id, slot_id):
    """
    ipc源数量
    :param device_id: 设备id
    :param slot_id: slot id
    :return:
    """
    return ipc_api.read_ipc_slot_source_count(device_id, slot_id)


def write_ipc_source_create_middle(device_id, slot_id, data):
    """
    ipc源创建
    :param device_id: 设备id
    :param slot_id: slot id
    :param data: data
    :return:
    """
    return ipc_api.write_ipc_source_create(device_id, slot_id, data)


def ipc_source_append_middle(device_id, data):
    """
    ipc源追加
    :param device_id: 设备id
    :param data: data
    :return:
    """
    return ipc_api.write_ipc_source_append(device_id, data)


def ipc_source_delete_middle(device_id, data):
    """
    删除输入信号源
    :param device_id: 设备id
    :param data: data
    :return: 结果对象
    """
    return ipc_api.write_ipc_source_delete(device_id, data)


def ipc_source_update_middle(device_id, source_id, data):
    """
    修改ipc general 信息
    :param device_id: slot id
    :param source_id: source
    :param data: general 信息
    :return: 结果对象
    """
    return ipc_api.write_ipc_source_general(device_id, source_id, data)


def ipc_write_channel_edit_middle(device_id, params):
    """
    修改通道数据
    :param device_id: 设备Id
    :param params: params
    :return 结果数据
    """
    return ipc_api.write_ipc_channel_edit(device_id, params)


def read_ipc_channel_detail_middle(device_id, source_id, channel_id):
    """
    读取信号源通道详情
    :param device_id: 设备Id
    :param source_id: 源Id
    :param channel_id: 通道Id
    :return 结果数据
    """
    return ipc_api.read_ipc_channel_detail(device_id, source_id, channel_id)


def ipc_channel_delete_middle(device_id, params):
    """
    删除通道数据
    :param device_id: 设备Id
    :param params: params
    :return 结果数据
    """
    return ipc_api.write_ipc_channel_delete(device_id, params)


def ipc_read_slot_source_count_middle(device_id, slot_id):
    """
    ipc slot 数量
    :param device_id: device_id
     :param slot_id: slot_id
    :return: 结果对象
    """
    return ipc_api.read_ipc_slot_source_count(device_id, slot_id)


def ipc_search_source_list_middle(device_id, data):
    """
    ipc 源搜索结果列表
    :param device_id: 设备Id
    :param data: 搜索参数
    :return:
    """
    return ipc_api.read_ipc_search_source_list(device_id, data)


def ipc_group_list_middle(device_id):
    """
    ipc分组列表
    :param device_id: 设备Id
    :return: 结果数据
    """
    return ipc_api.read_ipc_group_list(device_id)


def ipc_group_node_list_without_page_middle(device_id, group_id):
    """
    获取ipc分组全部节点数据，不分页
    :param device_id: 设备Id
    :param group_id: group_id
    :return: 结果数据
    """
    return ipc_api.read_ipc_group_node_list_without_page(device_id, group_id)


def ipc_group_create_middle(device_id, data):
    """
    ipc分组创建
    :param device_id: 设备Id
    :param data: data
    :return: 结果数据
    """
    return ipc_api.ipc_group_create(device_id, data)


def ipc_group_delete_middle(device_id, data):
    """
    获取ipc分组删除
    :param device_id: 设备Id
    :param data: data
    :return: 结果数据
    """
    return ipc_api.ipc_group_delete(device_id, data)


def ipc_group_clear_middle(device_id, group_id):
    """
    清除分组
    :param device_id: 设备Id
    :param group_id: group_id
    :return: 结果数据
    """
    data = {"deviceId": device_id, "groupId": group_id}
    return ipc_api.ipc_group_clear(device_id, group_id, data)


def ipc_group_update_middle(device_id, data):
    """
    更新分组
    :param device_id: 设备Id
    :param data: data
    :return: 结果数据
    """
    return ipc_api.ipc_group_update(device_id, data)


def ipc_group_node_delete_middle(device_id, data):
    """
    ipc分组删除节点
    :param device_id: 设备Id
    :param group_id: group_id
    :param data: data
    :return: 结果数据
    """
    return ipc_api.ipc_group_node_delete(device_id, data)


def ipc_montage_list_middle(device_id, slot_id):
    """
    ipc拼接源列表
    :param device_id: 设备Id
    :param slot_id: slot_id
    :return: 结果数据
    """
    return ipc_api.ipc_montage_list(device_id, slot_id)


def ipc_montage_template_create_middle(device_id, data):
    """
    ipc 拼接源创建模板
    :param device_id: device_id
    :param data: data
    :return:
    """
    return ipc_api.ipc_montage_template_create(device_id, data)


def ipc_montage_template_update_middle(device_id, data):
    """
    ipc 拼接源模板更新
    :param device_id: device_id
    :param data: data
    :return:
    """
    return ipc_api.ipc_montage_template_update(device_id, data)


def ipc_montage_template_delete_middle(device_id, data):
    """
    ipc 拼接源模板删除
    :param device_id: device_id
    :param data: data
    :return:
    """
    return ipc_api.ipc_montage_template_delete(device_id, data)


def ipc_montage_template_apply_middle(device_id, data):
    """
    ipc 拼接源应用模板
    :param device_id: device_id
    :param data: data
    :return:
    """
    return ipc_api.ipc_montage_template_apply(device_id, data)


def ipc_montage_rename_middle(device_id, data):
    """
    ipc 拼接源模板重命名
    :param device_id: device_id
    :param data: data
    :return:
    """
    return ipc_api.ipc_montage_rename(device_id, data)
