"""
Created on 2021年9月13日
@author: 程声清
返回值统一为 {data:JSON结构体, msg:"", status:0}
"""
from H_9U.mao.bkg_mao import bkg_api
from H_9U.service.middlewarefilepath import bkg_manager
from H_9U.util.fileopt import remove_file


def bkg_read_detail_middle(device_id, bkg_id):
    """
    读取bkg详情
    :param device_id: 设备id
    :param bkg_id:  bkg_id
    :return: 参考前端接口文档
    """
    rs = bkg_detail_middle(device_id, bkg_id)
    if rs['status'] == 0 and rs['data']:
        img_file = rs['data']['data']['image']['fileName']

        rs['data']['data']['image']['imgUrl'] = ''
        rs['data']['thumbnailData'] = {
            "deviceId": device_id,
            "bkgId": bkg_id,
            "image": {
                "fileName": '',
                "imgUrl": '',
                "fileLength": '',
                "hashSum": 0x55FF,
                "width": 0,
                "height": 0}}
        #  为bkg图片补充缩略图等信息
        if img_file:
            # bkg绝对路径，url； 缩略图绝对路径，url
            bkg_path, bkg_url, thumbnail_path, thumbnail_url = bkg_manager.get_bkg_path_info(
                img_file)
            rs['data']['data']['image']['imgUrl'] = bkg_url
            # 缩略图数据
            rs['data']['thumbnailData'] = {
                "deviceId": device_id,
                "bkgId": bkg_id,
                "image": {
                    "fileName": thumbnail_path,
                    "imgUrl": thumbnail_url,
                    "fileLength": 0,
                    "hashSum": 0x55FF,
                    "width": 0,
                    "height": 0}}
    return rs


def bkg_detail_middle(device_id, bkg_id):
    """
    读取bkg详情并加入缓存
    :param device_id: 设备id
    :param bkg_id: bkgId
    :return: 结果数据
    """
    return bkg_api.read_detail(device_id, bkg_id)


def write_create_middle(device_id, data):
    """
    创建bkg
    :param device_id: 设备Id
    :param data: bkg数据
    :return:
    """
    return bkg_api.write_create(device_id, data)


def bkg_delete_middle(device_id, bkg_id, data):
    """
    删除bkg
    :param device_id: 设备Id
    :param bkg_id: bkg Id
    :param data
    :return:  结果对象
    """
    return bkg_api.write_delete(device_id, bkg_id, data)


def bkg_read_list_middle(device_id):
    """
    读取bkg 列表
    :param device_id: 设备Id
    :return:  列表数据，不含详细信息
    """
    return bkg_api.read_list(device_id)


def bkg_detail_data_middle(device_id, bkg_id):
    """
    bkg数据处理
    :param device_id: 设备Id
     :param bkg_id:
     :return:  结果对象
    """
    data = {"deviceId": device_id, "bkgId": bkg_id}
    del_rs = bkg_read_detail_middle(device_id, bkg_id)
    rs = bkg_delete_middle(device_id, bkg_id, data)
    # 删除文件数据
    # 原始图片中间件负责移除
    if rs['status'] == 0 and del_rs['status'] == 0:
        remove_file(del_rs['data']['thumbnailData']['image']['fileName'])
    return rs
