from H_9U import get_result_model
from H_9U.protocol.fncode import FnCode
from H_9U.mao.impl.device import _device_detail_read, device_general_read, device_general_write, _device_slot_read, \
	device_slot_write, device_interface_read, write_device_interface_capacity, device_power_read, device_genlock_read, \
	device_genlock_write, device_slot_function_read, device_slot_function_write, device_ip_read, device_ip_write, \
	device_com_read, device_com_write, device_save_write, device_shutdown_write, device_restore_factory_write, \
	device_firware_version_read, device_upgrade_sts_read, device_self_check, device_self_check_status, \
	device_nomark_mode_read, device_nomark_mode_write, device_effective_time_read, device_effective_time_write, \
	device_hdr_support_read, device_language_read, device_language_write, device_local_time_write, \
	device_local_time_read, device_ipc_mode_read, device_ipc_mode_write, device_init_status_read, \
	device_guide_data_write, device_resource_mode_read, device_resource_mode_write, device_backup_mode_write, \
	device_backup_mode_read, device_type_read, device_background_color_write, device_background_color_read, \
	read_device_font_list, write_device_font_create, write_device_font_delete, read_device_central_cmd_list, \
	read_device_central_cmd_detail, write_device_central_cmd_create, write_device_central_cmd_modify, \
	write_device_central_cmd_delete, write_device_central_cmd_apply, read_lcd_config, write_lcd_config, \
	input_backup_read, input_backup_write, input_backup_list_read, input_backup_update, input_backup_delete, \
	bright_mode_read, bright_mode_write, write_audio_card_attribute, write_audio_interface_delay_time, \
	read_audio_card_detail, read_audio_card_list, read_fiber_detail


def get_device_info(code, operate, params):
	rs = get_result_model()
	if FnCode.DEVICE_DETAIL == int(code, 16):
		if operate == 1:
			rs = _device_detail_read(0)
	if FnCode.DEVICE_GENERAL == int(code, 16):
		if operate == 1:
			rs = device_general_read(0)
		if operate == 2:
			rs = device_general_write(0, params)
	if FnCode.DEVICE_SLOT == int(code, 16):
		if operate == 1:
			rs = _device_slot_read(0, params.get('slotId'))
		if operate == 2:
			rs = device_slot_write(0, params.get('slotId', 0), params)
	if FnCode.DEVICE_INTERFACE == int(code, 16):
		if operate == 1:
			rs = device_interface_read(0, params.get('slotId'), params.get('interfaceId'))
		if operate == 2:
			rs = write_device_interface_capacity(0, params.get('slotId', 0), params.get('interfaceId', 0), params)
	if FnCode.DEVICE_POWER == int(code, 16):
		if operate == 1:
			rs = device_power_read(0)
	if FnCode.DEVICE_GENLOCK == int(code, 16):
		if operate == 1:
			rs = device_genlock_read(0, params.get('genlockId', 0))
		if operate == 2:
			rs = device_genlock_write(0, params.get('genlockId', 0), params)
	if FnCode.DEVICE_SLOTFUNCTION == int(code, 16):
		if operate == 1:
			rs = device_slot_function_read(0, params.get('slotId', 0))
		if operate == 2:
			rs = device_slot_function_write(0, params.get('slotId', 0), params)
	if FnCode.DEVICE_IP == int(code, 16):
		if operate == 1:
			rs = device_ip_read(0)
		if operate == 2:
			rs = device_ip_write(0, params)
	if FnCode.DEVICE_COM == int(code, 16):
		if operate == 1:
			rs = device_com_read(0)
		if operate == 2:
			rs = device_com_write(0, params)
	if FnCode.DEVICE_SAVE == int(code, 16):
		if operate == 2:
			rs = device_save_write(0, params)
	if FnCode.DEVICE_SHUTDOWN == int(code, 16):
		if operate == 2:
			rs = device_shutdown_write(0, params)
	if FnCode.DEVICE_RESTOREFACTORY == int(code, 16):
		if operate == 2:
			rs = device_restore_factory_write(0, params)
	if FnCode.DEVICE_FIRWAREVERSION == int(code, 16):
		if operate == 1:
			rs = device_firware_version_read(0)
	if FnCode.DEVICE_UPGRADESTS == int(code, 16):
		if operate == 1:
			rs = device_upgrade_sts_read(0)
	if FnCode.DEVICE_SELF_CHECK == int(code, 16):
		if operate == 2:
			rs = device_self_check(0, params)
	if FnCode.DEVICE_SELF_CHECK_STS == int(code, 16):
		if operate == 1:
			rs = device_self_check_status(0)
	if FnCode.DEVICE_NOMARK_MODE == int(code, 16):
		if operate == 1:
			rs = device_nomark_mode_read(0)
		if operate == 2:
			rs = device_nomark_mode_write(0, params)
	if FnCode.DEVICE_EFFECTIVE_TIME == int(code, 16):
		if operate == 1:
			rs = device_effective_time_read(0)
		if operate == 2:
			rs = device_effective_time_write(0, params)
	if FnCode.DEVICE_HDR_SUPPORT == int(code, 16):
		if operate == 1:
			rs = device_hdr_support_read(0)
	if FnCode.DEVICE_LANGUAGE == int(code, 16):
		if operate == 1:
			rs = device_language_read(0)
		if operate == 2:
			rs = device_language_write(0, params)
	if FnCode.DEVICE_LOCAL_TIME == int(code, 16):
		if operate == 1:
			rs = device_local_time_read(0)
		if operate == 2:
			rs = device_local_time_write(0, params)
	if FnCode.DEVICE_IPC_OUT_MODE == int(code, 16):
		if operate == 1:
			rs = device_ipc_mode_read(0, params.get('slotId', 0))
		if operate == 2:
			rs = device_ipc_mode_write(0, params.get('slotId', 0), params)
	if FnCode.DEVICE_INIT_STATUS == int(code, 16):
		if operate == 1:
			rs = device_init_status_read(0)
	if FnCode.DEVICE_GUIDE_DATA == int(code, 16):
		if operate == 2:
			rs = device_guide_data_write(0, params)
	if FnCode.DEVICE_DYNAMIC_RESOURCES == int(code, 16):
		if operate == 1:
			rs = device_resource_mode_read(0)
		if operate == 2:
			rs = device_resource_mode_write(0, params)
	if FnCode.DEVICE_WORK_MODE == int(code, 16):
		if operate == 1:
			rs = device_backup_mode_read(0)
		if operate == 2:
			rs = device_backup_mode_write(0, params)
	if FnCode.DEVICE_TYPE == int(code, 16):
		if operate == 1:
			rs = device_type_read(0)
	if FnCode.DEVICE_BG_COLOR == int(code, 16):
		if operate == 1:
			rs = device_background_color_read(0)
		if operate == 2:
			rs = device_background_color_write(0, params)
	if FnCode.DEVICE_FONT_LIST == int(code, 16):
		if operate == 1:
			rs = read_device_font_list(0)
	if FnCode.DEVICE_FONT_CREATE == int(code, 16):
		if operate == 2:
			rs = write_device_font_create(0, params)
	if FnCode.DEVICE_FONT_DELETE == int(code, 16):
		if operate == 2:
			rs = write_device_font_delete(0, params)
	if FnCode.DEVICE_CENTRAL_CMD_LIST == int(code, 16):
		if operate == 1:
			rs = read_device_central_cmd_list()
	if FnCode.DEVICE_CENTRAL_CMD_FULL_DETAIL == int(code, 16):
		if operate == 1:
			rs = read_device_central_cmd_detail(0, params.get("cmdId"))
	if FnCode.DEVICE_CENTRAL_CMD_CREATE == int(code, 16):
		if operate == 2:
			rs = write_device_central_cmd_create(0, params)
	if FnCode.DEVICE_CENTRAL_CMD_MODIFY == int(code, 16):
		if operate == 2:
			rs = write_device_central_cmd_modify(0, params)
	if FnCode.DEVICE_CENTRAL_CMD_DELETE == int(code, 16):
		if operate == 2:
			rs = write_device_central_cmd_delete(0, params)
	if FnCode.DEVICE_CENTRAL_CMD_APPLY == int(code, 16):
		if operate == 2:
			rs = write_device_central_cmd_apply(0, params)
	if FnCode.DEVICE_LCD_ENABLE == int(code, 16):
		if operate == 1:
			rs = read_lcd_config(0)
		if operate == 2:
			rs = write_lcd_config(0, params)
	if FnCode.DEVICE_INPUT_BACKUP_SWITCH == int(code, 16):
		if operate == 1:
			rs = input_backup_read(0)
		if operate == 2:
			rs = input_backup_write(0, params.get("enable"), params.get("type"), params )
	if FnCode.DEVICE_INPUT_BACKUP_UPDATE == int(code, 16):
		if operate == 1:
			rs = input_backup_list_read(0)
		if operate == 2:
			rs = input_backup_update(0, params)
	if FnCode.DEVICE_INPUT_BACKUP_DELETE == int(code, 16):
		if operate == 2:
			rs = input_backup_delete(0, params)
	if FnCode.DEVICE_BRIGHT_MODE_SWITCH == int(code, 16):
		if operate == 1:
			rs = bright_mode_read(0)
		if operate == 2:
			rs = bright_mode_write(0, params)
	if FnCode.DEVICE_AUDIO_CARD_MODE == int(code, 16):
		if operate == 2:
			rs = write_audio_card_attribute(0, params.get("slotId"), params)
	if FnCode.DEVICE_AUDIO_INTERFACE_DELAY_TIME == int(code, 16):
		if operate == 2:
			rs = write_audio_interface_delay_time(0, params.get("slotId"), params)
	if FnCode.DEVICE_AUDIO_CARD_DETAIL == int(code, 16):
		if operate == 1:
			rs = read_audio_card_detail(0, params.get("slotId"))
	if FnCode.DEVICE_AUDIO_CARD_LIST == int(code, 16):
		if operate == 1:
			rs = read_audio_card_list(0)
	if FnCode.DEVICE_FIBER_CARD_DETAIL == int(code, 16):
		if operate == 1:
			rs = read_fiber_detail(0, params.get("slotId"))
	return rs

