"""
Created on 2021年9月06日
@author: 程声清
用户模块数据库访问
返回值统一为 {data:JSON结构体, msg:"", status:0}
"""
from H_9U.models.result import get_result_model, ResInfo
from H_9U.util.sqlitepool import sqllock, pool
from H_9U.util.log import logger


class OpenUserDao:

    def __init__(self, conn_pool):
        self.pool = conn_pool

    def get_user_info_by_p_id(self, p_id):
        """
        根据用户PId获取用户信息
        :param p_id: p_id
        :return: 用户信息
        """
        rs = get_result_model()
        try:
            sqllock.acquire()
            conn = self.pool.get()
            with conn:
                cursor = conn.cursor()
                cursor.execute(
                    "select id, pId, projectName, status, isEncrypt, secretKey from openUserInfo where pId=:p_id", {
                        "p_id": p_id})
                row = cursor.fetchone()
                if row:
                    rs['data'] = {
                        'id': row[0],
                        'pId': row[1],
                        'projectName': row[2],
                        'status': row[3],
                        'isEncrypt': row[4],
                        'secretKey': row[5]
                    }
        except Exception as e:
            logger.exception(e)
            rs = get_result_model(ResInfo.DB_Error)
        finally:
            if sqllock.locked():
                sqllock.release()
        return rs

    def get_user_info_by_key(self, key):
        """
        根据用户key获取用户信息
        :param key: key
        :return: 用户信息
        """
        rs = get_result_model()
        try:
            sqllock.acquire()
            conn = self.pool.get()
            with conn:
                cursor = conn.cursor()
                cursor.execute(
                    "select id, pId, projectName, status, isEncrypt, secretKey from openUserInfo where secretKey=:key", {
                        "key": key})
                row = cursor.fetchone()
                if row:
                    rs['data'] = {
                        'id': row[0],
                        'pId': row[1],
                        'projectName': row[2],
                        'status': row[3],
                        'isEncrypt': row[4],
                        'secretKey': row[5]
                    }
        except Exception as e:
            logger.exception(e)
            rs = get_result_model(ResInfo.DB_Error)
        finally:
            if sqllock.locked():
                sqllock.release()
        return rs

    def get_user_info_by_name(self, project_name):
        """
        根据name获取用户信息
        :param project_name: project_name
        :return: 用户信息
        """
        rs = get_result_model()
        try:
            sqllock.acquire()
            conn = self.pool.get()
            with conn:
                cursor = conn.cursor()
                cursor.execute(
                    "select id, pId, projectName, status, isEncrypt, secretKey from openUserInfo where projectName=:project_name", {
                        "project_name": project_name})
                row = cursor.fetchone()
                if row:
                    rs['data'] = {
                        'id': row[0],
                        'pId': row[1],
                        'projectName': row[2],
                        'status': row[3],
                        'isEncrypt': row[4],
                        'secretKey': row[5]
                    }
        except Exception as e:
            logger.exception(e)
            rs = get_result_model(ResInfo.DB_Error)
        finally:
            if sqllock.locked():
                sqllock.release()
        return rs

    def add_user_info(self, data):
        """
        添加项目信息
        :param data: data
        :return:
        """
        rs = get_result_model()
        try:
            sqllock.acquire()
            conn = self.pool.get()
            with conn:
                cursor = conn.cursor()
                cursor.execute(
                    "insert into openUserInfo(pId, projectName, status, isEncrypt, secretKey) values(?,?,1,0,?)",
                    (data.get('pId'), data.get('projectName'), data.get('secretKey')))
                cursor.execute('select last_insert_rowid() newid;')
                rows = cursor.fetchone()
                id = rows[0]
                conn.commit()
                rs['data']['id'] = id
        except Exception as e:
            logger.exception(e)
            rs = get_result_model(ResInfo.Open_Info_Add_Err)
        finally:
            if sqllock.locked():
                sqllock.release()
        return rs

    def get_user_info_by_id(self, id):
        """
        根据id获取信息
        :param id: id
        :return:
        """
        rs = get_result_model()
        try:
            sqllock.acquire()
            conn = self.pool.get()
            with conn:
                cursor = conn.cursor()
                cursor.execute(
                    "select id, pId, projectName, status, isEncrypt, secretKey from openUserInfo where id=:id", {
                        "id": id})
                row = cursor.fetchone()
                if row:
                    rs['data'] = {
                        'id': row[0],
                        'pId': row[1],
                        'projectName': row[2],
                        'status': row[3],
                        'isEncrypt': row[4],
                        'secretKey': row[5]
                    }
        except Exception as e:
            logger.exception(e)
            rs = get_result_model(ResInfo.DB_Error)
        finally:
            if sqllock.locked():
                sqllock.release()
        return rs

    def get_open_info_list(self):
        """
        获取全部信息列表
        :return:
         """
        rs = get_result_model()
        try:
            sqllock.acquire()
            conn = self.pool.get()
            with conn:
                cursor = conn.cursor()
                cursor.execute(
                    "select id, pId, projectName, status, isEncrypt, secretKey from openUserInfo order by id desc")
                rows = cursor.fetchall()
                open_user_info_list = []
                if rows:
                    for row in rows:
                        open_user_info_list.append({
                            'id': row[0],
                            'pId': row[1],
                            'projectName': row[2],
                            'status': row[3],
                            'isEncrypt': row[4],
                            'secretKey': row[5],
                        })
                rs['data'] = open_user_info_list
        except Exception as e:
            logger.exception(e)
            rs = get_result_model(ResInfo.DB_Error)
        finally:
            if sqllock.locked():
                sqllock.release()
        return rs

    def find_open_info_by_name(self, project_name):
        """
               获取全部信息列表
               :return:
                """
        rs = get_result_model()
        try:
            sqllock.acquire()
            conn = self.pool.get()
            with conn:
                cursor = conn.cursor()
                sql = "select id, pId, projectName, status, isEncrypt, secretKey from openUserInfo where projectName like '%" + project_name + "%'"
                cursor.execute(sql)
                rows = cursor.fetchall()
                open_user_info_list = []
                if rows:
                    for row in rows:
                        open_user_info_list.append({
                            'id': row[0],
                            'pId': row[1],
                            'projectName': row[2],
                            'status': row[3],
                            'isEncrypt': row[4],
                            'secretKey': row[5],
                        })
                rs['data'] = open_user_info_list
        except Exception as e:
            logger.exception(e)
            rs = get_result_model(ResInfo.DB_Error)
        finally:
            if sqllock.locked():
                sqllock.release()
        return rs

    def update_user_info_by_id(self, id, data):
        """
        更新用户状态
        :param id: id
        :param data: data
        :return: 标准返回
        """
        rs = get_result_model()
        try:
            sqllock.acquire()
            conn = self.pool.get()
            conditions = []
            for key in data:
                conditions.append('{}=:{}'.format(key, key))
            sql = "update openUserInfo set " + \
                ', '.join(conditions) + " where id=:id"
            data['id'] = id
            with conn:
                cursor = conn.cursor()
                cursor.execute(sql, data)
                conn.commit()
        except Exception as e:
            logger.exception(e)
            rs = get_result_model(ResInfo.Open_Info_Update_Err)
        finally:
            if sqllock.locked():
                sqllock.release()
        return rs

    def delete_open_info(self, id):
        """
        删除第三方信息
        :param id: id
        :return: 结果对象
        """
        rs = get_result_model()
        try:
            sqllock.acquire()
            conn = self.pool.get()
            with conn:
                cursor = conn.cursor()
                cursor.execute(
                    "delete from openUserInfo where id=:id", {
                        "id": id})
                conn.commit()
        except Exception as e:
            logger.exception(e)
            rs = get_result_model(ResInfo.Open_Info_Delete_Err)
        finally:
            if sqllock.locked():
                sqllock.release()
        return rs


openuserdao = OpenUserDao(pool)
