"""
Created on 2019年8月28日
@author: 刘益宗
主动上报推送处理
"""
import time
from threading import Thread

from H_9U.api.device import device_begin_upgrade, device_upgrade_from_usb
from H_9U.api.device import device_detail, slot_detail, device_upgrade_status, device_self_check_status, \
    device_setting_status, audio_card_list, genLock_status_read
from H_9U.api.input import input_read_all_list
from H_9U.api.ipc import ipc_montage_list, ipc_slot_montage_list
from H_9U.api.layer import screen_layer_detail_list
from H_9U.api.main import init_status
from H_9U.api.output import output_read_all_list
from H_9U.api.screen import screen_list, screen_read_hdr, __build_layer_list
from H_9U.api.websender import push_by_upload, push_org_by_upload
from H_9U.conf.syssettings import SysSettings
from H_9U.ctrl.up.evtType import EvtType
from H_9U.models.cachekey import CacheKey
from H_9U.models.syncdataname import SyncDataName
from H_9U.models.sysconst import CardType, ModelId, ST2110Card
from H_9U.service.layer import layer_svc
from H_9U.service.screen import screen_svc
from H_9U.util.cache import cacher
from H_9U.util.log import logger

_mac = None
middlewaretoken = 'middlewaretoken'

def get_mac(device_id):
    """
    获取mac地址
    :param device_id: 设备Id
    :return: mac地址
    """
    global _mac
    if not _mac:
        try:
            from H_9U import app
            from flask import g
            with app.app_context():
                g.token = middlewaretoken
                device = device_detail(device_id)
                if device['status'] == 0:
                    _mac = device.get('data', {}).get('MAC','')
        except Exception as e:
            pass
    return _mac


class EventHandler2:
    """
    事件处理函数
    一定间隔内，相同事件只处理一次
    """
    def __init__(self):
        self._event_set = set()  # 事件集合
        self._interval = 5  # 处理事件间隔
        Thread(target=self._upload_event_handler).start()  # 时间处理函数

    def add_event(self, data):
        """
        添加事件
        :param data:
        :return:
        """
        self._event_set.add(data)

    def clear_event(self):
        """
        清空待处理事件集合
        :return:
        """
        self._event_set.clear()

    def _upload_event_handler(self):
        device_id = SysSettings.Device_Id
        while True:
            try:
                # logger.info("主动上报任务启动：" + str(datetime.datetime.now()))
                if self._event_set:
                    # 有待处理事件，清空事件集合，依次处理
                    lst = list(self._event_set)
                    self.clear_event()

                    device_push = False
                    screen_push = False
                    # 先判断是否有slotevent
                    slot_evts = [x for x in lst if x[0] == EvtType.SLOT_STATUS]
                    if slot_evts:
                        device_push = True
                        push_by_upload(device_detail, 'MIDDLE', middlewaretoken, SyncDataName.Device_Read_Detail,
                                       device_id)
                        only_output = False
                        inputs = None
                        flag = False
                        if not [x for x in slot_evts if x[4] == 0]:  # 0表示有卡上下限
                            from H_9U import app
                            app_ctx = app.app_context()
                            app_ctx.push()
                            from flask import g
                            g.token = middlewaretoken
                            rs = device_detail(device_id)
                            app_ctx.pop()
                            if rs['status'] == 0 and rs['data']:

                                input_slots = set(
                                    [x['slotId'] for x in rs['data']['slotList'] if x['cardType'] == CardType.In])
                                inputs = list(input_slots)
                                push_slot = set([x[3] for x in lst if x[0] == EvtType.SLOT_STATUS])
                                if push_slot and input_slots and not(input_slots & push_slot):
                                    only_output = True
                                card_type_list = list(set([x[5] for x in lst if x[0] == EvtType.SLOT_STATUS]))
                                for x in card_type_list:
                                    if x == CardType.Out or x == CardType.Sender:
                                        flag = True
                        if not only_output and not flag:
                            cacher.clear_all()
                            push_org_by_upload('MIDDLE', middlewaretoken,
                                               SyncDataName.Input_IPC_Source_Refresh, {'deviceId': 0})
                            push_by_upload(input_read_all_list, 'MIDDLE', middlewaretoken, SyncDataName.Input_Read_List,
                                           device_id)
                            push_by_upload(output_read_all_list, 'MIDDLE', middlewaretoken, SyncDataName.Output_Read_List,
                                           device_id)
                            push_org_by_upload('MIDDLE', middlewaretoken,
                                               SyncDataName.MVR_Window_Read_All_Info, {'deviceId': 0})

                            push_by_upload(ipc_montage_list, 'MIDDLE', middlewaretoken,
                                           SyncDataName.Input_IPC_Montage_List, device_id)
                            # 先退输入源相关列表，再退屏幕，否则无源图层问题无法解决
                            push_by_upload(screen_list, 'MIDDLE', middlewaretoken,
                                           SyncDataName.Screen_Read_All_List, device_id)

                            screen_push = True
                    ipc_channel_list = set([x for x in lst if x[0] == EvtType.IPC_URL_STATUS])
                    if ipc_channel_list:
                        cacher.LayerCache.clear()
                        sources = set()
                        device_id = 0
                        for c in ipc_channel_list:
                            source_id, channel_id = c[3], c[4]
                            cacher.IPCCache.delete(CacheKey.ipc_channel_detail(device_id, source_id, channel_id))
                            from H_9U.api.ipc import ipc_channel_detail
                            push_by_upload(ipc_channel_detail, 'MIDDLE', middlewaretoken,
                                           SyncDataName.Input_IPC_Channel_Edit,
                                           device_id, source_id, channel_id)
                            sources.add(source_id)
                        for s in sources:
                            cacher.IPCCache.delete(CacheKey.ipc_source_channel_list(device_id, s))
                            cacher.IPCCache.delete(CacheKey.ipc_source_channel_detail_list(device_id, s))
                        if not screen_push:
                            push_by_upload(screen_list, 'MIDDLE', middlewaretoken, SyncDataName.Screen_Read_All_List, device_id)

                    ipc_montage_status_list = set([x for x in lst if x[0] == EvtType.IPCMontageStatus])
                    if ipc_montage_status_list:
                        for montage_slot in ipc_montage_status_list:
                            device_id, slot_id = montage_slot[2], montage_slot[3]

                            push_by_upload(ipc_slot_montage_list, 'MIDDLE', middlewaretoken,
                                           SyncDataName.Input_IPC_Slot_Montage_List, device_id, slot_id)

                    if [x for x in lst if x[0] == EvtType.BOX_STATUS] and not device_push:
                        push_by_upload(device_detail, 'MIDDLE', middlewaretoken, SyncDataName.Device_Read_Detail,
                                           device_id)
                    # if [x for x in lst if x[0] == EvtType.HDR_SUPPORT] and not screen_related_push:
                    #     push_by_upload(screen_list,  'MIDDLE', middlewaretoken, SyncDataName.Screen_Read_All_List,
                    #                    device_id)
            except Exception as e:
                self._event_set.clear()
                logger.error(e)
            time.sleep(self._interval)


_handler = EventHandler2()


def event_handle(event):
    """
    主动上报事件处理
    :param event: 事件
    :return: 无
    """

    # 升级、自检、导入导出，不处理
    if device_upgrade_status() or device_self_check_status() or device_setting_status():
        return
    # mac地址不匹配不执行
    mac = event.mac
    device_id = event.deviceId
    local_mac = get_mac(device_id)

    if local_mac:
        if local_mac.lower() != mac.lower():
            return
    print("上报事件类型event====", event)
    logger.info('推送MAC：%s，本机MAC %s， 推送事件： %s' % (mac, local_mac, event))

    # 设备初始化不成功，不执行
    try:
        from H_9U import app
        from flask import g
        with app.app_context():
            g.token = 'web_handler_token'
            if not init_status():
                return
    except Exception as e:
        pass


    global _up_set
    # 槽位变化
    if event.evtType == EvtType.SLOT_STATUS:
        slot_id = event.slotId
        slot_status = event.slotStatus
        card_type = event.cardType
        # 清空缓存
        cacher.clear_all()
        _handler.add_event((EvtType.SLOT_STATUS, event.evtSender.name, device_id, slot_id, slot_status, card_type))
        from H_9U import app
        from flask import g
        with app.app_context():
            g.token = middlewaretoken
            # web前端刷新设备界面,子卡与物理接口状态
            push_by_upload(device_detail, 'MIDDLE', middlewaretoken, SyncDataName.Device_Read_Detail, device_id)
            rs = slot_detail(device_id, slot_id)
            if rs['status'] == 0 and rs['data']:
                # web前端 刷新卡槽属性面板
                push_org_by_upload(event.evtSender.name, middlewaretoken, SyncDataName.Device_Read_Slot, rs['data'])
            audio_rs = audio_card_list(device_id)
            if audio_rs['status'] == 0 and audio_rs['data']:
                push_org_by_upload(event.evtSender.name, middlewaretoken, SyncDataName.Device_Audio_List, audio_rs['data'])
            # 优化推送,如果是输出卡的状态变化,不在推送屏幕列表
            if card_type not in[CardType.Out, CardType.Sender]:
                from H_9U.api.screen import screen_list
                screen_rs = screen_list(device_id)
                if screen_rs['status'] == 0 and screen_rs['data']:
                    push_org_by_upload(event.evtSender.name, middlewaretoken, SyncDataName.Screen_Read_All_List,
                                       screen_rs['data'])
            genLock_status_rs = genLock_status_read(device_id)
            if genLock_status_rs['status'] == 0 and genLock_status_rs['data']:
                push_org_by_upload(event.evtSender.name, middlewaretoken, SyncDataName.Device_Read_GenLock_Status,
                                   genLock_status_rs['data'])
    # 机箱状态变化
    elif event.evtType == EvtType.BOX_STATUS:
        # 清空设备详情缓存
        cacher.DeviceCache.delete(CacheKey.device_detail(device_id))
        _handler.add_event((EvtType.BOX_STATUS, event.evtSender.name, device_id))
        # hdr support变化
    elif event.evtType == EvtType.HDR_SUPPORT:
        pass
        # key = CacheKey.device_hdr_support(device_id)
        # cacher.DeviceCache.delete(key)
        # _handler.add_event((EvtType.HDR_SUPPORT, event.evtSender.name, device_id))
        # cacher.DeviceCache.clear()
    elif event.evtType == EvtType.IPC_URL_STATUS:
        device_id, source_id, channel_id = event.deviceId, event.sourceId, event.channelId
        _handler.add_event((EvtType.IPC_URL_STATUS, event.evtSender.name, device_id, source_id, channel_id))
    elif event.evtType == EvtType.IPCMontageStatus:
        device_id, slot_id, montage_id = event.deviceId, event.slotId, event.montageId
        _handler.add_event((EvtType.IPCMontageStatus, event.evtSender.name, device_id, slot_id))
    # 实时推送 场景轮巡
    elif event.evtType == EvtType.PRESET_POOL:
        logger.info("receive hw report EvtType.PRESET_POOL,tag:2")
        cacher.LayerCache.clear()
        from H_9U import app
        from flask import g
        if event.data:
            logger.info("嵌入式上报时,携带的数据")
            event_data = event.data
            logger.info(event_data)
            with app.app_context():
                screen_data = event_data['screen']
                screen_id = screen_data['screenId']
                g.token = middlewaretoken
                push_data = {
                    'deviceId': event.deviceId,
                    'screenId': screen_id,
                    'presetId': event_data['presetId'],
                    'layoutTemplateId': event_data['layoutTemplateId'],
                    'layers': screen_data['layers'],
                    'nonTime': screen_data['nonTime'],
                    'audio': screen_data['audio'],
                }
                #if screen_data['nonTime'] == 1: #非实时模式
                    #push_data['audio'] = screen_data['noTimeAudio']

                push_org_by_upload(event.evtSender.name, middlewaretoken, SyncDataName.Preset_Poll_Play,push_data)
                osd_data = {
                    "deviceId": device_id,
                    "screenId": screen_id,
                    "Osd": event_data['Osd'],
                    "OsdImage": event_data['OsdImage']
                }
                push_org_by_upload(event.evtSender.name, middlewaretoken, SyncDataName.Screen_Write_OSD, osd_data)
                bkg_id = screen_data['Bkg']['bkgId']
                bkg_data = {
                    "deviceId": device_id,
                    "bkgId": bkg_id,
                    "screenId": screen_id,
                    "enable": screen_data['Bkg']['enable']
                }
                from H_9U.api.bkg import bkg_image_url
                bkg_rs = bkg_image_url(device_id, bkg_id)
                if bkg_rs['status'] == 0 and bkg_rs['data'] and bkg_rs['data']['imageUrl']:
                    bkg_data['imageUrl'] = bkg_rs['data']['imageUrl']
                push_org_by_upload(event.evtSender.name, middlewaretoken, SyncDataName.Screen_Write_BKG, bkg_data)
        else:
            with app.app_context():
                data = {
                    'deviceId': event.deviceId,
                    'screenId': event.screenId,
                    'presetId': event.presetId,
                    'layoutTemplateId': event.layoutTemplateId,  # 布局id
                    'layers': [],
                    'nonTime': 0
                }
                g.token = middlewaretoken
                # 获取屏幕下图层数据
                rs = screen_layer_detail_list(event.deviceId, event.screenId)
                if rs['status'] == 0:
                    data['layers'] = rs['data']
                from H_9U.api.screen import screen_detail
                detail = screen_detail(event.deviceId, event.screenId)
                if detail['status'] == 0:
                    data['nonTime'] = detail['data']['nonTime']
                    # 音频数据
                    data['audio'] = detail['data']['audio']
                push_org_by_upload(event.evtSender.name, middlewaretoken, SyncDataName.Preset_Poll_Play, data)
                osd_data = {
                    "deviceId": device_id,
                    "screenId": event.screenId,
                    "Osd": detail['data']['Osd'],
                    "OsdImage": detail['data']['OsdImage']
                }
                push_org_by_upload(event.evtSender.name, middlewaretoken, SyncDataName.Screen_Write_OSD, osd_data)
                bkg_data = {
                    "deviceId": device_id,
                    "imageUrl": detail['data']['Bkg']['imgUrl'],
                    "bkgId": detail['data']['Bkg']['bkgId'],
                    "screenId": event.screenId,
                    "enable": detail['data']['Bkg']['enable']
                }
                push_org_by_upload(event.evtSender.name, middlewaretoken, SyncDataName.Screen_Write_BKG, bkg_data)
    # 升级事件，优先处理
    elif event.evtType == EvtType.UPGRADE:
        if SysSettings.Local_Device_Type == 1:  # H系类
            device_begin_upgrade()
            device_upgrade_from_usb()
    # 大屏亮度
    elif event.evtType == EvtType.SCREENBRIGHTNESS:
        from H_9U import app
        from flask import g
        with app.app_context():
            g.token = middlewaretoken
            data = {
                "screenId": event.screenId,
                "deviceId": device_id,
                "brightness": event.brightness,
                "clientType": event.clientType
            }
            push_org_by_upload(event.evtSender.name, middlewaretoken, SyncDataName.Screen_Brightness, data)
    # hdr 变化
    elif event.evtType == EvtType.SCREENHDR:
        from H_9U import app
        from flask import g
        with app.app_context():
            g.token = middlewaretoken

            rs = screen_read_hdr(device_id, event.screenId)
            if rs['status'] == 0:
                push_org_by_upload(event.evtSender.name, middlewaretoken, SyncDataName.Screen_Write_HDR, rs['data'])
    elif event.evtType == EvtType.STD_IO_Card_STATUS or event.evtType == EvtType.OUTPUT_BACKUP_STATUS:
        # 清空设备详情缓存
        cacher.DeviceCache.delete(CacheKey.device_detail(device_id))
        push_by_upload(device_detail, event.evtSender.name, middlewaretoken, SyncDataName.Device_Read_Detail,
                       device_id)
        if event.evtType == EvtType.STD_IO_Card_STATUS:
            slot_id = event.slotId
            cacher.DeviceCache.delete(CacheKey.device_slot(device_id, slot_id))
            from H_9U import app
            from flask import g
            with app.app_context():
                g.token = middlewaretoken
                rs = slot_detail(device_id, slot_id)
                if rs['status'] == 0 and rs['data']:
                    push_org_by_upload(event.evtSender.name, middlewaretoken, SyncDataName.Device_Read_Slot, rs['data'])

    elif event.evtType == EvtType.LanguageMode:
        lang = event.lang
        data = {'languageMode': 1 if lang == 'zh' else 0 if lang == 'en' else 2}
        from H_9U import app
        from flask import g
        with app.app_context():
            g.token = middlewaretoken
            push_org_by_upload(event.evtSender.name, middlewaretoken, SyncDataName.LanguageMode, data)

    elif event.evtType == EvtType.ScreenAudioChanged:
        cacher.clear_all()
        data = {
            'deviceId': event.deviceId,
            'screenId': event.screenId,
            'nonTime': 0,
            "audio": None,
            "screenLayers": None
        }
        from H_9U import app
        from flask import g
        with app.app_context():
            g.token = middlewaretoken
            from H_9U.api.screen import screen_detail
            rs = screen_detail(device_id, event.screenId)
            if rs['status'] == 0:
                if rs['data']['nonTime'] == 0:
                    data['nonTime'] = rs['data']['nonTime']
                    data['audio'] = rs['data']['audio']
                    data['screenLayers'] = rs['data']['screenLayers']
                if rs['data']['nonTime'] == 1:
                    from H_9U.api.screen import screen_non_time_detail
                    noTime_rs = screen_non_time_detail(device_id, event.screenId)
                    if rs['status'] == 0:
                        data['nonTime'] = rs['data']['nonTime']
                        data['audio'] = noTime_rs['data']['noTimeAudio']
                        data['screenLayers'] = noTime_rs['data']['layers']
                push_org_by_upload(event.evtSender.name, middlewaretoken, SyncDataName.Screen_Audio_Changed, data)

    elif event.evtType == EvtType.GenLockChanged:
        # genlock 数据变化
        push_org_by_upload(event.evtSender.name, middlewaretoken, SyncDataName.Device_Read_GenLock,
                           {'deviceId': device_id})
        from H_9U import app
        from flask import g
        with app.app_context():
            g.token = middlewaretoken
            genLock_status_rs = genLock_status_read(device_id)
            if genLock_status_rs['status'] == 0 and genLock_status_rs['data']:
                push_org_by_upload(event.evtSender.name, middlewaretoken, SyncDataName.Device_Read_GenLock_Status,
                                   genLock_status_rs['data'])
    elif event.evtType == EvtType.UpdateScreenOsd:
        screen_id = event.screenId
        from H_9U import app
        from flask import g
        with app.app_context():
            g.token = middlewaretoken
            from H_9U.api.screen import screen_detail
            detail = screen_detail(device_id, screen_id)
            if detail['status'] == 0 and detail['data']:
                osd_data = {
                    "deviceId": device_id,
                    "screenId": screen_id,
                    "Osd": detail['data']['Osd'],
                    "OsdImage": detail['data']['OsdImage']
                }
                push_org_by_upload(
                    event.evtSender.name, middlewaretoken, SyncDataName.Screen_Write_OSD, osd_data)
                bkg_data = {
                    "deviceId": device_id,
                    "imageUrl": detail['data']['Bkg']['imgUrl'],
                    "bkgId": detail['data']['Bkg']['bkgId'],
                    "screenId": screen_id,
                    "enable": detail['data']['Bkg']['enable']
                }
                push_org_by_upload(event.evtSender.name, middlewaretoken, SyncDataName.Screen_Write_BKG, bkg_data)

    elif event.evtType == EvtType.FiberModeChanged:
        input_id = event.inputId
        from H_9U import app
        from flask import g
        with app.app_context():
            g.token = middlewaretoken
            from H_9U.api.input import input_detail
            detail = input_detail(device_id, input_id)
            push_org_by_upload(
                event.evtSender.name,
                middlewaretoken,
                SyncDataName.Input_Read_Detail,
                detail)
    elif event.evtType == EvtType.VideoStreamingChanged:
        slot_id = event.slotId
        slot_status = event.slotStatus
        data = {
            "slotId": slot_id,
             "loadStatus": slot_status
        }
        from H_9U import app
        from flask import g
        with app.app_context():
            g.token = middlewaretoken
            push_org_by_upload(
                event.evtSender.name,
                middlewaretoken,
                SyncDataName.Device_Slot_VideoStreamChanged,
                data)
    elif event.evtType == EvtType.IPCOnLineChanged:
        source_list = event.sourceList
        group_id = event.groupId
        data = {
            "sourceList": source_list,
            "groupId": group_id
        }
        from H_9U import app
        from flask import g
        with app.app_context():
            g.token = middlewaretoken
            push_org_by_upload(
                event.evtSender.name,
                middlewaretoken,
                SyncDataName.Input_IPC_IsOnline_Status,
                data)

    elif event.evtType == EvtType.SourceDataChanged:
        source_type = event.sourceType
        source_id = event.sourceId
        width = event.width
        height = event.height
        data = {
            "sourceType": source_type,
            "sourceId": source_id,
            "width": width,
            "height": height,
        }
        from H_9U import app
        from flask import g
        with app.app_context():
            g.token = middlewaretoken
            push_org_by_upload(
                event.evtSender.name,
                middlewaretoken,
                SyncDataName.Ndi_Source_Change,
                data)

    elif event.evtType == EvtType.LedOsdChanged:
        cacher.clear_all()
        screen_id = event.screenId
        from H_9U import app
        from flask import g
        with app.app_context():
            g.token = middlewaretoken
            from H_9U.api.screen import screen_detail
            detail = screen_detail(device_id, screen_id)
            if detail['status'] == 0:
                data = {
                    "deviceId": device_id,
                    "screenId": screen_id,
                    "Osd": detail['data']['Osd'],
                    "OsdImage": detail['data']['OsdImage']
                }
                push_org_by_upload(
                    event.evtSender.name,
                    middlewaretoken,
                    SyncDataName.Screen_Write_OSD,
                    data)

    elif event.evtType == EvtType.LedScreenShutDown:
        from H_9U import app
        from flask import g
        with app.app_context():
            g.token = middlewaretoken
            from H_9U.api.device import lcd_detail
            detail = lcd_detail(device_id)
            if detail['status'] == 0:
                push_org_by_upload(
                    event.evtSender.name,
                    middlewaretoken,
                    SyncDataName.Device_Write_Lcd_config,
                    detail['data'])

    elif event.evtType == EvtType.Led3DChanged:
        cacher.clear_all()
        screen_id = event.screenId
        from H_9U import app
        from flask import g
        with app.app_context():
            g.token = middlewaretoken
            from H_9U.mao.impl import screen
            detail = screen.screen_full_detail_read(device_id, screen_id)
            if detail['status'] == 0:
                data_3d = {
                    "deviceId": device_id,
                    "screenId": screen_id,
                    "screen3D": detail['data']['screen3D']
                }
                push_org_by_upload(event.evtSender.name, middlewaretoken, SyncDataName.Screen_Write_3D, data_3d)

    elif event.evtType == EvtType.OSDWeatherChanged:
            device_id = event.deviceId
            screen_id = event.screenId
            osd_id = event.osdId
            from H_9U import app
            from flask import g
            with app.app_context():
                g.token = middlewaretoken
                # 读取屏幕的osd信息
                weather_rs = screen_svc.osd_weather_read(device_id, screen_id, osd_id)
                if weather_rs['status'] == 0:
                    push_org_by_upload(event.evtSender.name, middlewaretoken, SyncDataName.Screen_Weather_Changed,
                                       weather_rs['data'])
    elif event.evtType == EvtType.DeviceTimeChanged:
        # 设备时间变化 需要更新时间OSD组件
        from H_9U import app
        from flask import g
        with app.app_context():
            g.token = middlewaretoken
            push_org_by_upload(event.evtSender.name, middlewaretoken, SyncDataName.Device_Time_Changed, event.data)
    elif event.evtType == EvtType.MvrGroupPollStatus:
        mvr_group_poll_input_list = event.mvrGroupPollInputList
        from H_9U import app
        from flask import g
        with app.app_context():
            g.token = middlewaretoken
            push_org_by_upload(event.evtSender.name, middlewaretoken, SyncDataName.MVR_Window_Group_Poll_Status,
                               mvr_group_poll_input_list)
    elif event.evtType == EvtType.LayerChanged:
        logger.info("v1990,receive hw report,tag:25,EvtType.LayerChanged")
        screen_list = event.screenList
        from H_9U import app
        from flask import g
        with app.app_context():
            g.token = middlewaretoken
            push_org_by_upload(event.evtSender.name, middlewaretoken, SyncDataName.Layer_Exceed_Limit, screen_list)
    elif event.evtType == EvtType.InputSourceChanged:
        #logger.info("v1990B2T1,receive hw report,tag:17,EvtType.InputSourceChanged")
        from H_9U import app
        from flask import g
        with app.app_context():
            g.token = middlewaretoken
            cacher.ScreenCache.clear()
            cacher.LayerCache.clear()
            source_id = event.sourceId
            zorder = event.zorder
            data = {
                "sourceId": source_id,
                "zorder": zorder
            }
            push_org_by_upload(event.evtSender.name, middlewaretoken, SyncDataName.Input_Source_Training_Sort, data)

            from H_9U.api.screen import screen_detail
            use_list = event.useList
            for x in use_list:
                screen_id = x['screenId']
                layer_id = x['layerId']
                rs = screen_detail(device_id,screen_id)
                if rs['status'] == 0:
                    if rs['data']['nonTime'] == 0: # 实时模式
                        layer_rs = layer_svc.full_detail(device_id, screen_id, layer_id)
                        push_org_by_upload(event.evtSender.name, middlewaretoken, SyncDataName.Layer_Write_Source, layer_rs['data'])
                        continue
                    if rs['data']['nonTime'] == 1: # 非实时模式
                        from H_9U.api.screen import screen_non_time_detail
                        noTime_rs = screen_non_time_detail(device_id, screen_id)
                        if noTime_rs['status'] == 0:
                            detail = [x for x in noTime_rs['data']['layers'] if x['layerId'] == layer_id]
                            layer_data = detail[0] if detail else {}
                            push_org_by_upload(event.evtSender.name, middlewaretoken, SyncDataName.Layer_Write_Source, layer_data)
                            continue
    elif event.evtType == EvtType.InputSourceUsedChange:
        from H_9U import app
        from flask import g
        with app.app_context():
            g.token = middlewaretoken
            source_id = event.sourceId
            is_used = event.isUsed
            data = {
                "sourceId": source_id,
                "isUsed": is_used
            }
            push_org_by_upload(event.evtSender.name, middlewaretoken, SyncDataName.Input_Source_IsUsed, data)
    elif event.evtType == EvtType.InputSourceSubList:
        logger.info("v1990B1T2,receive hw report,tag:36,EvtType.InputSourceSubList")
        from H_9U import app
        from flask import g
        with app.app_context():
            g.token = middlewaretoken
            data = {
                "sourceId": event.sourceId,
                "subList": event.subList
            }
            push_org_by_upload(event.evtSender.name, middlewaretoken, SyncDataName.Input_SubSourceList, data)

    elif event.evtType == EvtType.NoTimeSourceDataChange:
        logger.info("v1990B1T2,receive hw report,tag:37,EvtType.NoTimeSourceDataChange")
        from H_9U import app
        from flask import g
        with app.app_context():
            g.token = middlewaretoken
            data =  event.layer
            push_org_by_upload(event.evtSender.name, middlewaretoken, SyncDataName.Notime_Source_Changed, data)
    elif event.evtType == EvtType.ST2110ModeStatus:
        slot_id = event.slotId
        logger.info("v2000B1,revive hw report tag:38 EvtType.ST2110ModeStatus,slot_id:%s",slot_id)
        cacher.clear_all()
        from H_9U import app
        from flask import g
        with app.app_context():
            g.token = middlewaretoken
            if event.status == ST2110Card.ModeStatus_Fail:
                logger.info("ST2110子卡切换失败")
                # ST2110子卡切换失败
                push_data = {"slotId": slot_id, "st2110ModeStatus": ST2110Card.ModeStatus_Fail, "modelId":ModelId.H_1xST2110_I, "deviceId":0}
                push_org_by_upload(event.evtSender.name, middlewaretoken, SyncDataName.Device_Read_Slot, push_data)
            else:
                rs = slot_detail(device_id, slot_id)
                if rs['status'] == 0 and rs['data']:
                    push_org_by_upload(event.evtSender.name, middlewaretoken, SyncDataName.Device_Read_Slot, rs['data'])
    elif event.evtType == EvtType.InputGroupNodeDel:
        logger.info("v2000B1,revive hw report tag:39 EvtType.InputGroupNodeDel,data:%s", event.data)
        cacher.clear_all()
        from H_9U import app
        from flask import g
        with app.app_context():
            g.token = middlewaretoken
            push_org_by_upload(event.evtSender.name, middlewaretoken, SyncDataName.Input_Group_Node_Del, event.data)
