
from flask import Blueprint
from flask import jsonify
from flask.globals import request, g

from H_9U.service.user import usersvc
from H_9U.util.logwrapper import api_log
from H_9U.models.result import ResInfo, get_result_model
from H_9U.util.common import valid_json, valid_params
from H_9U.util.logutil import LogOperation, LogModule, LogFunction, add_opt_log

session_bp = Blueprint('session', __name__)


@session_bp.route('/readList', methods=['GET', 'POST'])
@api_log
def api_session_list():
    """日志下载
    :return: 参考前端接口文档readDetail
    """
    params = valid_json(request.get_data().decode())
    if not params:
        return jsonify(get_result_model(ResInfo.Request_Json_Error))

    values = valid_params(params, 'deviceId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id = values
    rs = usersvc.token_list(device_id)
    return jsonify(rs)


@session_bp.route('/remove', methods=['GET', 'POST'])
@api_log
def api_session_remove():
    """
    删除会话
    """
    params = valid_json(request.get_data().decode())
    if not params:
        return jsonify(get_result_model(ResInfo.Request_Json_Error))

    values = valid_params(params, 'deviceId', 'token')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id, token = values
    if token == g.token:
        return get_result_model(ResInfo.User_Func_Err)
    rs = usersvc.get_login_user(token)
    if rs['status'] == 0 and rs['data']:
        usersvc.logout(token)
        add_opt_log(LogModule.Session, LogFunction.Session, LogOperation.Delete,
                    "remove login user :{0} success".format(rs['data']['username']))

    return jsonify(get_result_model())

