"""
Created on 2019年6月28日
@author: 刘益宗
log日志接口.
返回值统一为 {data:JSON结构体, msg:"", status:0}
"""
import datetime
from builtins import str
from io import BytesIO
import os
import shutil
import time
import traceback
import zipfile

from flask import Blueprint
from flask import jsonify
from flask.globals import request
from flask import send_file

from H_9U import BASE_DIR
from H_9U import controller
from H_9U.conf.syssettings import SysSettings
from H_9U.protocol.fncode import FnCode
from H_9U.util.fileopt import list_all_file
from H_9U.util.log import logger
from H_9U.util.logutil import LogModule, LogType
from H_9U.util.logwrapper import api_log
from H_9U.models.result import ResInfo, get_result_model
from H_9U.util.common import valid_json, valid_params
from H_9U.service.log import logsvc


log_bp = Blueprint('log', __name__)


@log_bp.route('/export', methods=['GET', 'POST'])
@api_log
def export():
    """
    日志下载
    """
    params = valid_json(request.get_data().decode())
    if not params:
        return jsonify(get_result_model(ResInfo.Request_Json_Error))

    values = valid_params(params, 'deviceId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id = values

    try:
        log_dir = os.path.abspath(os.path.join(BASE_DIR, "../../log"))
        if not os.path.exists(log_dir):
            os.makedirs(log_dir)
        # 导出系统硬件日志
        export_hardware_log()
        target_dir = SysSettings.Device_Download_Path
        target_file = os.path.join(target_dir, 'logs.zip')

        if os.path.exists(target_dir):
            if os.path.exists(target_file):
                os.remove(target_file)
        else:
            os.mkdir(target_dir)
        file_list = list_all_file(log_dir)
        with zipfile.ZipFile(target_file, "w", zipfile.ZIP_DEFLATED) as zf:
            for _file in file_list:
                with open(os.path.join(log_dir, _file), 'rb') as fp:
                    zf.writestr(_file, fp.read())
            if os.path.exists(SysSettings.Middleware_Abs_Path):
                for _file in list_all_file(SysSettings.Middleware_Abs_Path):
                    file_path = os.path.join(SysSettings.Middleware_Abs_Path, _file)
                    with open(os.path.join(SysSettings.Middleware_Abs_Path, _file), 'rb') as fp:
                        zf.writestr(_file, fp.read())
                        file_stat = os.stat(file_path)
                        mtime = datetime.datetime.fromtimestamp(file_stat.st_mtime)
                        zip_date_time = (
                            mtime.year,
                            mtime.month,
                            mtime.day,
                            mtime.hour,
                            mtime.minute,
                            mtime.second
                        )
                        year, month, day, hour, minute, second = zip_date_time
                        year = max(1980, min(year, 67415))
                        month = max(1, min(month, 12))
                        day = max(1, min(day, 31))
                        hour = max(0, min(hour, 23))
                        minute = max(0, min(minute, 59))
                        second = max(0, min(second, 59))
                        if not (1980 <= year <= 67415):
                           logger.info("year", year)
                        zip_info = zf.getinfo(_file)
                        zip_date_time = (year, month, day, hour, minute, second)
                        zip_info.date_time = zip_date_time
        from H_9U.api.device import read_domain
        domain = read_domain(device_id)
        file_url = target_file[target_file.index('download'):]
        rs = get_result_model()
        rs['data'] = {
            'deviceId': device_id,
            'fileUrl': domain + file_url

        }
        return jsonify(rs)
    except ValueError as ex:
        msg = str(ex)
        if '1980' in msg or 'timestamps' in msg:
            return jsonify(get_result_model(ResInfo.Device_Date_Err))
        else:
            return jsonify(get_result_model(ResInfo.Server_Err))
    except Exception as e:
        logger.error(e)
        msg = traceback.format_exc()
        logger.error('日志下载-失败!异常信息:%s' % msg)
        return jsonify(get_result_model(ResInfo.Server_Err))


def export_hardware_log():
    """导出系统硬件日志.
    """
    rs = controller.write(FnCode.DEVICE_EXPORTLOG, [{"deviceId":0}])

    if rs != None:
        if rs.get("status") == 0:
            logger.warning("导出系统硬件日志-成功!")
        else:
            logger.error("导出系统硬件日志-失败:CODE:%i" % rs.get("status"))
    else:
        logger.error("导出系统硬件日志-失败:rs为空!")


@log_bp.route('/loginList', methods=['GET', 'POST'])
@api_log
def api_login_list():
    """
    登陆日志
    """
    params = valid_json(request.get_data().decode())
    if not params:
        return jsonify(get_result_model(ResInfo.Request_Json_Error))

    values = valid_params(params, 'deviceId', 'pageIndex', 'pageSize')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id, index, size = values
    begin = params.get('begin', None)
    end = params.get('end', None)
    log_module = LogModule.Login
    log_type = LogType.Login
    rs = logsvc.paged_log_list(log_type, log_module, index, size, begin, end, 'desc')
    return jsonify(rs)


@log_bp.route('/optList', methods=['GET', 'POST'])
@api_log
def api_opt_list():
    """
    操作日志
    """
    params = valid_json(request.get_data().decode())
    if not params:
        return jsonify(get_result_model(ResInfo.Request_Json_Error))

    values = valid_params(params, 'deviceId', 'pageIndex', 'pageSize')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id, index, size = values
    begin = params.get('begin', None)
    end = params.get('end', None)
    log_module = None
    log_type = LogType.Operation
    rs = logsvc.paged_log_list(log_type, log_module, index, size, begin, end, 'desc')
    return jsonify(rs)


@log_bp.route('/loginDelete', methods=['GET', 'POST'])
@api_log
def api_log_login_delete():
    """
    日志删除
    """
    params = valid_json(request.get_data().decode())
    if not params:
        return jsonify(get_result_model(ResInfo.Request_Json_Error))

    values = valid_params(params, 'deviceId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    begin = params.get('begin', None)
    end = params.get('end', None)
    rs = logsvc.delete_log_list(LogType.Login, begin, end)
    return jsonify(rs)


@log_bp.route('/optDelete', methods=['GET', 'POST'])
@api_log
def api_log_opt_delete():
    """
    日志删除
    """
    params = valid_json(request.get_data().decode())
    if not params:
        return jsonify(get_result_model(ResInfo.Request_Json_Error))

    values = valid_params(params, 'deviceId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    begin = params.get('begin', None)
    end = params.get('end', None)
    rs = logsvc.delete_log_list(LogType.Operation, begin, end)
    return jsonify(rs)
