"""
Created on 2023年2月2日
@author: 程声清
screen_filter
返回值统一为 {data:JSON结构体, msg:"", status:0}
"""
from H_9U.models.sysconst import UserRoleType


def _filter_list_screen_func(role_type, role_data, data):
    """
    数据过滤
    :param role_type: role_type
    :param role_data: role_data
    :param data: data
    :return: 数据
    """
    if role_type == UserRoleType.Admin_Role:
        return data
    screen_id_list = [x['screenId'] for x in role_data]
    screen_list = []
    if data:
        for screen in data:
            screen_id = screen['screenId']
            if screen_id in screen_id_list:
                screen_list.append(screen)
    return screen_list


def _filter_screen_func(role_type, role_data, data):
    """
    推送数据过滤
    :param data_message: 推送数据
    :param role_id: 角色Id
    :return: 数据
    """
    if role_type == UserRoleType.Admin_Role:
        return data
    if data:
        screen_id = data['screenId']
        screen_id_list = [x['screenId'] for x in role_data]
        if screen_id in screen_id_list:
            return data
        else:
            data = None
    else:
        data = None
    return data
