from flask.globals import request
from flask.json import jsonify
from flask import Blueprint

from H_9U.service import embed
from H_9U.util.logwrapper import api_log

from H_9U.util.common import valid_json, valid_params
from H_9U.models.result import get_result_model, ResInfo

embed_bp = Blueprint('embed', __name__)

@embed_bp.route('/tool', methods=['GET', 'POST'])
@api_log
def api_embed_info():
	params = valid_json(request.get_data().decode())
	if not params:
		return jsonify(get_result_model(ResInfo.Request_Json_Error))
	values = valid_params(params, 'code', 'operate', 'params')
	if values is None:
		return jsonify(get_result_model(ResInfo.Params_Error))
	code, operate, req_data = values
	rs = embed.auto_detail(code, operate, req_data)
	return jsonify(rs)