"""
Created on 2019年6月28日
@author: 刘益宗
主程序入口
启动系统并初始化
"""
import json
import logging.config
import os
import shutil
import time
import traceback
import uuid

from flask import Flask, request, jsonify
from flask import g

from H_9U.conf.syssettings import SysSettings
from H_9U.ctrl.down.controller import Controller
from H_9U.models.result import get_result_model, ResInfo
from H_9U.models.sysconst import DeviceConfig
from H_9U.service.role import rolesvc
from H_9U.util.common import valid_dict_value, valid_params, valid_json, compare_elements
from H_9U.util.log import logger, log_info
from H_9U.util.request_handle import request_parameter_resolution, response_parameter_resolution
from H_9U.util.signature_encryption import des_decrypt, des_encrypt, signature_encrypt_sign, param_isinstance
from H_9U.util.signature_encryption import signature_encrypt

BASE_DIR = os.path.dirname(os.path.abspath(__file__))

# 创建日志目录
os.makedirs('../log', exist_ok=True)

# 初始化log
logging.config.fileConfig(
    os.path.join(
        BASE_DIR,
        'conf/log.conf'))   # r"H_9U/conf/log.conf")

# 初始化socket_io
# socket_io = SocketIO()  # 新添加的代码

# 创建下行-通讯控制器
controller = Controller()
# 创建上行-数据采集器


# 初始化app
app = Flask(__name__, static_url_path='')



try:
    if os.path.exists(SysSettings.Middleware_Version_Type_Path):
        with open(SysSettings.Middleware_Version_Type_Path, 'r') as f:
            version_type = json.load(f)
            SysSettings.Version_Type = version_type['versionType']
            logger.info('当前系统版本类型：%s' % version_type)
except Exception as e:
    logger.error('读取版本类型文件异常：%s' % e)


def _register():
    """
    # 路由和其他处理程序定义
    # 注册蓝图
    :return:
    """
    from H_9U.api.user import user_bp  # 从当前目录下面的main子目录中导入main对象
    from H_9U.api.role import role_bp
    from H_9U.api.bkg import bkg_bp
    from H_9U.api.device import device_bp
    from H_9U.api.input import input_bp
    from H_9U.api.output import output_bp
    from H_9U.api.layer import layer_bp
    from H_9U.api.mvrwindow import mvr_window_bp
    from H_9U.api.preset import preset_bp
    from H_9U.api.screen import screen_bp
    from H_9U.api.main import main_bp
    from H_9U.api.log import log_bp
    from H_9U.api.ipc import ipc_bp
    from H_9U.api.security import security_bp
    from H_9U.api.session_api import session_bp
    from H_9U.api.ndi import ndi_bp
    from H_9U.api.network import network_bp
    from H_9U.api.embed import embed_bp

    from H_9U.open.api.open_main import open_main_bp  # 从当前目录下面的main子目录中导入main对象
    from H_9U.open.api.open_input import open_input_bp
    from H_9U.open.api.open_screen import open_screen_bp
    from H_9U.open.api.open_output import open_output_bp
    from H_9U.open.api.open_layer import open_layer_bp
    from H_9U.open.api.open_bkg import open_bkg_bp
    from H_9U.open.api.open_preset import open_preset_bp
    from H_9U.open.api.open_ipc import open_ipc_bp
    from H_9U.open.api.open_device import open_device_bp


    app.register_blueprint(user_bp, url_prefix='/api/user')
    app.register_blueprint(role_bp, url_prefix='/api/role')
    app.register_blueprint(bkg_bp, url_prefix='/api/bkg')
    app.register_blueprint(device_bp, url_prefix='/api/device')
    app.register_blueprint(input_bp, url_prefix='/api/input')
    app.register_blueprint(output_bp, url_prefix='/api/output')
    app.register_blueprint(layer_bp, url_prefix='/api/layer')
    app.register_blueprint(mvr_window_bp, url_prefix='/api/mvrWindow')
    app.register_blueprint(preset_bp, url_prefix='/api/preset')
    app.register_blueprint(screen_bp, url_prefix='/api/screen')
    app.register_blueprint(main_bp, url_prefix='/api/main')
    app.register_blueprint(log_bp, url_prefix='/api/log')
    app.register_blueprint(ipc_bp, url_prefix='/api/ipc')
    app.register_blueprint(security_bp, url_prefix='/api/security')
    app.register_blueprint(session_bp, url_prefix='/api/session')
    app.register_blueprint(ndi_bp, url_prefix='/api/ndi')
    app.register_blueprint(network_bp, url_prefix='/api/network')
    app.register_blueprint(network_bp, url_prefix='/api/network')
    app.register_blueprint(embed_bp, url_prefix='/embed')

    app.register_blueprint(open_bkg_bp, url_prefix='/open/api/bkg')
    app.register_blueprint(open_input_bp, url_prefix='/open/api/input')
    app.register_blueprint(open_output_bp, url_prefix='/open/api/output')
    app.register_blueprint(open_layer_bp, url_prefix='/open/api/layer')
    app.register_blueprint(open_preset_bp, url_prefix='/open/api/preset')
    app.register_blueprint(open_screen_bp, url_prefix='/open/api/screen')
    app.register_blueprint(open_main_bp, url_prefix='/open/api/main')
    app.register_blueprint(open_ipc_bp, url_prefix='/open/api/ipc')
    app.register_blueprint(open_device_bp, url_prefix='/open/api/device')


def valid_init_status():
    """
    socket通信controller状态
    :return:True-初始化完毕、False-初始化进行中
    """
    status = controller.getInitStatus()
    return status


def valid_self_check_status():
    """
    设备自建状态
    :return: True：自检中，false：自建完成
    """
    from H_9U.service.device import device_svc
    return device_svc.read_self_check_status()


def valid_upgrade_status():
    """
    固件升级状态
    :return: True正在升级，False 非升级
    """
    from H_9U.service.device import device_svc
    return device_svc.read_upgrade_status()


def valid_device_settings_status():
    from H_9U.service.device import device_svc
    return device_svc.read_setting_file_operate_status()


@app.before_request
def global_before_request():
    """
    拦截器函数，拦截所有请求
    :return:
    """
    # 获取token和请求接口
    path = request.path
    token = request.headers.get('token', None)
    g.request_id = str(uuid.uuid4())
    g.token = token
    ip = '127.0.0.1'
    try:
        if request.headers.getlist("X-Forwarded-For"):
            ip = request.headers.getlist("X-Forwarded-For")[0]
            if ',' in ip:
                for x in ip.split(','):
                    if x != '127.0.0.1':
                        ip = x
                        break
            else:
                ip = request.headers.getlist("X-Forwarded-For")[0]
        else:
            ip = request.remote_addr
    except Exception as e:
        logger.error(e)
    g.ip = ip
    
    # 校验初始化状态和升级状态
    if path not in SysSettings.Init_Url and not valid_init_status():
        return jsonify(get_result_model(ResInfo.Device_Is_Initing))
    if valid_upgrade_status() and path not in SysSettings.Upgrade_Url:
        return jsonify(get_result_model(ResInfo.Device_Is_Upgrading))
    if valid_self_check_status() and path not in SysSettings.Device_Self_Check_Url:
        return jsonify(get_result_model(ResInfo.Device_Is_Checking))
    if valid_device_settings_status():
        return jsonify(get_result_model(ResInfo.Device_Is_Setting))

    if path.startswith('/api'):
        g.start_time = time.time()
        log_info(f"API START | Path: {request.path}, Method: {request.method}, Client: {request.remote_addr}")
        # 判断是否是登录请求
        if path not in SysSettings.Not_Valid_Token_Url:
            # 没有token数据，返回
            if not token:
                rs = get_result_model(ResInfo.User_Not_Login)
                return jsonify(rs)
            # 验证token是否有效
            from H_9U.service.user import usersvc
            user_rs = usersvc.verify_auth_token(token)
            if user_rs['status'] != 0:
                return jsonify(user_rs)
            else:
                from H_9U.dao.user import userdao
                user_message = userdao.get_by_id(user_rs['data']['id'])
                if user_message['status'] != 0 or len(user_message['data']) == 0:
                    # 用户被删除 退出
                    return jsonify(get_result_model(ResInfo.User_Token_Expired))
                else:
                    # 用户无效 退出
                    if user_message['data']['status'] == 0:
                        rs = get_result_model(ResInfo.User_Token_Expired)
                        return jsonify(rs)
                from H_9U.dao.role import roledao
                role_rs = roledao.get_role_by_user_id(user_rs['data']['id'])
                if role_rs['status'] == 0 and role_rs['data']:
                    user_rs['data']['roleId'] = role_rs['data']['roleId']
                g.user = user_rs['data']

    if path.startswith('/open/api'):
        # 获取pid以及签名
        json_param = request.get_json()
        resolution = request_parameter_resolution(json_param)
        # 初始化变量
        g.is_encrypt = 0
        g.pId = 0
        if not resolution:
            return jsonify(response_parameter_resolution(get_result_model(ResInfo.Params_Error)))
        body_ = json_param['body']
        sign = json_param['sign']
        p_id = json_param['pId']
        time_stamp = json_param['timeStamp']
        if not param_isinstance(p_id, sign, time_stamp, 2):
            return jsonify(response_parameter_resolution(get_result_model(ResInfo.Params_Type_Error)))
        g.token = p_id
        g.pId = p_id
        from H_9U.open.middle import open_user_middle
        open_user_rs = open_user_middle.get_user_info(p_id)
        if open_user_rs['status'] != 0:
            return jsonify(response_parameter_resolution(get_result_model(ResInfo.Open_Project_Illegal_Err)))
        if not open_user_rs['data']:
            return jsonify(response_parameter_resolution(get_result_model(ResInfo.Open_Id_Illegal_Err)))
        g.project_name = open_user_rs['data']['projectName']
        g.is_encrypt = open_user_rs['data']['isEncrypt']
        user = {
            "username": open_user_rs['data']['projectName'],
            "token": g.token
        }
        g.user = user
        if open_user_rs['data']['status'] != 1:
            return jsonify(response_parameter_resolution(get_result_model(ResInfo.Open_Project_Illegal_Err)))
        # 参数加密传输
        if g.is_encrypt == 1:
            secret_key = open_user_rs['data']['secretKey']
            g.secretKey = secret_key
            if not param_isinstance(body_, None, None, 1):
                return jsonify(response_parameter_resolution(get_result_model(ResInfo.Params_Type_Error)))
            # 验证签名是否正确
            encrypt = signature_encrypt(
                body_, time_stamp, p_id, secret_key)
            if encrypt != sign:
                return jsonify(response_parameter_resolution(get_result_model(ResInfo.Params_Error)))
            # 解析body
            body = des_decrypt(body_, secret_key)
            params = valid_json(body)
            if not valid_dict_value(params):
                return jsonify(response_parameter_resolution(get_result_model(ResInfo.Params_Error)))
            open_user_rs['data'] = params
            g.data = open_user_rs['data']
        # 参数无加密传输
        if g.is_encrypt == 0:
            if not param_isinstance(body_, None, None, 0):
                return jsonify(response_parameter_resolution(get_result_model(ResInfo.Params_Type_Error)))
            # 验证签名是否正确
            encrypt = signature_encrypt_sign(
                time_stamp, p_id)
            if encrypt != sign:
                return jsonify(response_parameter_resolution(get_result_model(ResInfo.Sign_Error)))
            if not valid_dict_value(body_):
                return jsonify(response_parameter_resolution(get_result_model(ResInfo.Params_Type_Error)))
            g.data = body_


@app.after_request
def open_after_request(res):
    """
    :param res: 响应信息
    :return: 处理后的响应
    """
    if request.path.startswith('/api'):
        request_id = getattr(g, 'request_id', None)
        # HTTP Response Header
        if request_id:
            res.headers['X-Request-ID'] = request_id

        # 计算请求耗时
        duration = time.time() - g.get('start_time', time.time())
        msg = ""
        if duration >= 3:
            msg = "耗时异常"
        log_info(f"API END | Path: {request.path}, Status: {res.status_code}, Duration: {duration:.3f}s {msg}")
    if not request.path.startswith('/open'):
        return res
    biz_rs = res.json
    # 将业务返回结果中的status、msg、data拿出来，组装openAPI返回数据结果
    msg = biz_rs['msg']
    status = biz_rs['status']
    # 初始化响应数据格式
    open_rs = {
        'msg': msg,
        'status': status,
        'sign': '',
        'body': '',
    }
    if status != 0:
        return jsonify(open_rs)
    return jsonify(response_parameter_resolution(biz_rs))


@app.errorhandler(Exception)
def err_handler(err):
    """
    统一错误处理函数
    :param err:
    :return:
    """
    # noinspection PyBroadException
    try:
        msg = traceback.format_exc()
        logger.error("未处理异常%s" % msg)
    except Exception as e:
        logger.error("未处理异常%s" % str(e))
    rs = get_result_model(ResInfo.Server_Err)
    return jsonify(rs)


@app.route('/')
def index():
    return app.send_static_file('index.html')


# websocket启动
from H_9U.api.websocket import WebSocketServerThread
webSocketServerThread = WebSocketServerThread()
webSocketServerThread.start()

# udp 监听服务启动
from H_9U.api.udpmonitorthread import UdpMonitorThread
udp_thread = UdpMonitorThread()
udp_thread.start()

from H_9U.ctrl.up.collector import Collector
collector = Collector()

def clear_directory_contents(dir_path):
    """清空目录内容但保留目录本身"""
    for filename in os.listdir(dir_path):
        file_path = os.path.join(dir_path, filename)
        try:
            if os.path.isfile(file_path) or os.path.islink(file_path):
                os.unlink(file_path)  # 删除文件或链接
            elif os.path.isdir(file_path):
                shutil.rmtree(file_path)  # 删除子目录
        except Exception as e:
            logger.error(e)



try:
    link_from = os.path.abspath(os.path.join('../', 'helpfile'))
    link_to = os.path.join(BASE_DIR, 'static', 'helpfile')
    if not os.path.exists(link_to) and os.path.exists(link_from):
        os.symlink(link_from, link_to)
    # 创建或清空升级文件夹
    clear_directory_contents(SysSettings.Upload_Upgrade_File_Path)
except Exception as e:
    logger.error(e)


# 获取flask app实例
def get_app():
    _register()
    return app
