#!/bin/bash

# 创建日志目录
LOG_DIR="./Middleware/log/"
mkdir -p "$LOG_DIR"

# 获取当前时间戳
get_timestamp() {
    date '+%Y%m%d_%H%M%S'
}

# 日志轮转函数
rotate_logs() {
    local logfile="$LOG_DIR/system_monitor.log"
    local max_size=10485760    # 10MB
    local max_files=5       # 最多保留5个文件
    
    if [ -f "$logfile" ]; then
        local filesize=$(stat -c%s "$logfile" 2>/dev/null || echo 0)
        if [ "$filesize" -gt "$max_size" ]; then
            # 删除最旧的日志文件（如果存在）
            if [ -f "${logfile}.${max_files}" ]; then
                rm -f "${logfile}.${max_files}"
            fi
            
            # 将现有日志文件向后重命名
            i=$((max_files-1))
            while [ $i -ge 1 ]; do
                if [ -f "${logfile}.${i}" ]; then
                    mv "${logfile}.${i}" "${logfile}.$((i+1))"
                fi
                i=$((i-1))
            done
            
            # 将当前日志文件重命名为.1
            mv "$logfile" "${logfile}.1"
            
            # 创建新的日志文件
            touch "$logfile"
        fi
    fi
}

# 主循环函数
monitor_system() {
    while true; do

        rotate_logs
        timestamp=$(get_timestamp)
        echo "=== 系统监控时间: $(date) ===" | tee -a "$LOG_DIR/system_monitor.log"
        
        # 执行 cat /proc/meminfo 并保存
        echo "--- /proc/meminfo ---" | tee -a "$LOG_DIR/system_monitor.log"
        cat /proc/meminfo | tee -a "$LOG_DIR/system_monitor.log"
        echo "" | tee -a "$LOG_DIR/system_monitor.log"
        
        # 执行 free 命令并保存
        echo "--- free 命令结果 ---" | tee -a "$LOG_DIR/system_monitor.log"
        free | tee -a "$LOG_DIR/system_monitor.log"
        echo "" | tee -a "$LOG_DIR/system_monitor.log"
        
        # 执行 top 命令（非交互模式）并保存
        echo "--- top 命令结果 ---" | tee -a "$LOG_DIR/system_monitor.log"
        top -b -n 1 | head -20 | tee -a "$LOG_DIR/system_monitor.log"
        echo "" | tee -a "$LOG_DIR/system_monitor.log"
        
        # 添加分隔线
        echo "==========================================" | tee -a "$LOG_DIR/system_monitor.log"
        echo "" | tee -a "$LOG_DIR/system_monitor.log"
        
        # 等待1小时
        sleep 3600
    done
}

# 检查是否已经运行
if pgrep -f "monitor_system.sh" > /dev/null; then
    echo "监控脚本已经在运行中..."
    exit 1
fi

echo "开始系统监控，日志文件保存在: $LOG_DIR/system_monitor.log"
echo "按 Ctrl+C 停止监控"
echo ""

# 启动监控
monitor_system