#!/bin/sh

#更新boot和kernel
dd if=/usr/Hseries/tmp/Data_CtrlCard/hseries-loader.img of=/dev/mmcblk0p1
dd if=/usr/Hseries/tmp/Data_CtrlCard/hseries-kernel.img of=/dev/mmcblk0p6

#解压压缩包
tar -jxf /usr/Hseries/tmp/Data_CtrlCard/cert.tar.bz2        -C /etc/

tar -jxf /usr/Hseries/tmp/Data_CtrlCard/node.tar.bz2        -C /usr/Hseries/tmp/Data_CtrlCard/
tar -jxf /usr/Hseries/tmp/Data_CtrlCard/H_9U.tar.bz2        -C /usr/Hseries/tmp/Data_CtrlCard/
tar -jxf /usr/Hseries/tmp/Data_CtrlCard/GUI.tar.bz2         -C /usr/Hseries/tmp/Data_CtrlCard/
tar -jxf /usr/Hseries/tmp/Data_CtrlCard/font.tar.bz2        -C /usr/Hseries/tmp/Data_CtrlCard/
tar -jxf /usr/Hseries/tmp/Data_CtrlCard/openssh.tar.bz2     -C /usr/Hseries/tmp/Data_CtrlCard/
tar -jxf /usr/Hseries/tmp/Data_CtrlCard/openssl.tar.bz2     -C /usr/Hseries/tmp/Data_CtrlCard/
sync

#给文件增加可执行权限
chmod +x -R /usr/Hseries/tmp/Data_CtrlCard/*


if [ ! -d /usr/Hseries/bin/web/data/ ];then
    mkdir /usr/Hseries/bin/web/data/
fi

if [ ! -f /usr/Hseries/bin/web/data/h9u.db ];then
    echo "move h9u.db"
    if [ -f /usr/Hseries/bin/web/h9u.db ];then
        cp /usr/Hseries/bin/web/h9u.db /usr/Hseries/bin/web/data/
    else
        cp /usr/Hseries/bin/web/H_9U/H_9U/conf/h9u.db /usr/Hseries/bin/web/data/
    fi
fi

if [ ! -e /etc/init.d/automode ];then
	cp /usr/Hseries/tmp/Data_CtrlCard/automode	/etc/init.d/
    chmod +x /etc/init.d/automode
	ln -s /etc/init.d/automode /etc/rc5.d/S05automode
fi

if [ -f /usr/Hseries/tmp/Data_CtrlCard/site-packages.zip ]; then
    cd /usr/Hseries/tmp/Data_CtrlCard
    unzip site-packages.zip
    cp  site-packages/*  /usr/Hseries/lib/python3.6/lib/python3.6/site-packages/ -a
    rm -rf site-packages
    cd -
fi

if [ -f /etc/nginx/modules-enabled ];then
    mv /etc/nginx/modules-enabled /etc/nginx/modules-enabled_bk
fi

#升级rootfs
cp -rf /usr/Hseries/tmp/Data_CtrlCard/rootfs/* /

####
killall nginx

#升级压缩包内容
rm /usr/Hseries/bin/Middleware/node -rf
cp -rf /usr/Hseries/tmp/Data_CtrlCard/node                   /usr/Hseries/bin/Middleware/

#更新字体库
rm /usr/Hseries/bin/Middleware/font -rf
cp -rf /usr/Hseries/tmp/Data_CtrlCard/font                   /usr/Hseries/bin/Middleware/
if [ ! -d /usr/share/fonts/chinese ];then
    mkdir -p /usr/share/fonts/chinese
fi
cp /usr/Hseries/tmp/Data_CtrlCard/NotoSansHans-Regular.otf /usr/share/fonts/chinese
 
#更新液晶程序
cp /usr/Hseries/tmp/Data_CtrlCard/GUI/H9U_GUI            /usr/Hseries/bin/GUI -f 
cp /usr/Hseries/tmp/Data_CtrlCard/GUI/PlayerServer       /usr/Hseries/bin/GUI -f
cp /usr/Hseries/tmp/Data_CtrlCard/GUI/Config.json        /usr/Hseries/bin/GUI -f

#更新WEB程序
rm /usr/Hseries/bin/web/H_9U -rf
cp -rf /usr/Hseries/tmp/Data_CtrlCard/H_9U  /usr/Hseries/bin/web/H_9U
 
#更新ngnix
cp /usr/Hseries/tmp/Data_CtrlCard/nginx.conf        	   /etc/nginx/ -f
cp /usr/Hseries/tmp/Data_CtrlCard/nginx                    /usr/sbin/
 
#更新snmp
killall SnmpServer
rm /usr/Hseries/bin/web/snmp -rf
cp -r /usr/Hseries/tmp/Data_CtrlCard/snmp                  /usr/Hseries/bin/web/
 
#更新openssh
cp -rf /usr/Hseries/tmp/Data_CtrlCard/openssh/sbin 	       		/usr/
cp -rf /usr/Hseries/tmp/Data_CtrlCard/openssh/bin 	       		/usr/
cp -rf /usr/Hseries/tmp/Data_CtrlCard/openssl/libcrypto.so.1.1  /usr/lib/arm-linux-gnueabihf/
cp -rf /usr/Hseries/tmp/Data_CtrlCard/openssl/libssl.so.1.1     /usr/lib/arm-linux-gnueabihf/
cp -rf /usr/Hseries/tmp/Data_CtrlCard/openssl/openssl           /usr/bin/

if [ -d /usr/Hseries/tmp/Data_CtrlCard/helpfile ];then
    echo "change helpfile"
    rm -rf /usr/Hseries/bin/web/helpfile 
    cp -r /usr/Hseries/tmp/Data_CtrlCard/helpfile /usr/Hseries/bin/web/
fi

if [ ! -d  "/var/empty" ];then
	mkdir /var/empty
fi

/usr/bin/fc-cache
sync
rm /usr/Hseries/tmp/Data_CtrlCard/CtrlCardExec.sh

(echo "Pass123Word!";sleep 1;echo "Pass123Word!")|passwd >/dev/null

sync

sleep 2 && cd /usr/Hseries/bin && sh Hseries-shutdown.sh &
